/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Contains localized labels used in messenger apps")
public class LocalizedLabels
implements Serializable {
    private KeyEnum key = null;
    private String value = null;

    public LocalizedLabels key(KeyEnum key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains localized label key used in messenger homescreen")
    @JsonProperty(value="key")
    public KeyEnum getKey() {
        return this.key;
    }

    public void setKey(KeyEnum key) {
        this.key = key;
    }

    public LocalizedLabels value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="Contains localized label value used in messenger homescreen")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedLabels localizedLabels = (LocalizedLabels)o;
        return Objects.equals((Object)this.key, (Object)localizedLabels.key) && Objects.equals(this.value, localizedLabels.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LocalizedLabels {\n");
        sb.append("    key: ").append(this.toIndentedString((Object)this.key)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=KeyEnumDeserializer.class)
    public static enum KeyEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MESSENGERHOMEHEADERTITLE("MessengerHomeHeaderTitle"),
        MESSENGERHOMEHEADERSUBTITLE("MessengerHomeHeaderSubTitle");

        private String value;

        private KeyEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KeyEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KeyEnum value : KeyEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KeyEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class KeyEnumDeserializer
    extends StdDeserializer<KeyEnum> {
        public KeyEnumDeserializer() {
            super(KeyEnumDeserializer.class);
        }

        public KeyEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return KeyEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

