/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AutoStart;
import com.mypurecloud.sdk.v2.model.ConversationDisconnectSettings;
import com.mypurecloud.sdk.v2.model.Markdown;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Conversation settings that handles chats within the messenger")
public class ConversationAppSettings
implements Serializable {
    private Boolean showAgentTypingIndicator = null;
    private Boolean showUserTypingIndicator = null;
    private AutoStartTypeEnum autoStartType = null;
    private AutoStart autoStart = null;
    private Markdown markdown = null;
    private ConversationDisconnectSettings conversationDisconnect = null;

    public ConversationAppSettings showAgentTypingIndicator(Boolean showAgentTypingIndicator) {
        this.showAgentTypingIndicator = showAgentTypingIndicator;
        return this;
    }

    @ApiModelProperty(example="null", value="The toggle to enable or disable typing indicator for messenger")
    @JsonProperty(value="showAgentTypingIndicator")
    public Boolean getShowAgentTypingIndicator() {
        return this.showAgentTypingIndicator;
    }

    public void setShowAgentTypingIndicator(Boolean showAgentTypingIndicator) {
        this.showAgentTypingIndicator = showAgentTypingIndicator;
    }

    public ConversationAppSettings showUserTypingIndicator(Boolean showUserTypingIndicator) {
        this.showUserTypingIndicator = showUserTypingIndicator;
        return this;
    }

    @ApiModelProperty(example="null", value="The toggle to enable or disable typing indicator for messenger")
    @JsonProperty(value="showUserTypingIndicator")
    public Boolean getShowUserTypingIndicator() {
        return this.showUserTypingIndicator;
    }

    public void setShowUserTypingIndicator(Boolean showUserTypingIndicator) {
        this.showUserTypingIndicator = showUserTypingIndicator;
    }

    public ConversationAppSettings autoStartType(AutoStartTypeEnum autoStartType) {
        this.autoStartType = autoStartType;
        return this;
    }

    @ApiModelProperty(example="null", value="Deprecated. The auto start type for the messenger conversation")
    @JsonProperty(value="autoStartType")
    public AutoStartTypeEnum getAutoStartType() {
        return this.autoStartType;
    }

    public void setAutoStartType(AutoStartTypeEnum autoStartType) {
        this.autoStartType = autoStartType;
    }

    public ConversationAppSettings autoStart(AutoStart autoStart) {
        this.autoStart = autoStart;
        return this;
    }

    @ApiModelProperty(example="null", value="The auto start for the messenger conversation")
    @JsonProperty(value="autoStart")
    public AutoStart getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(AutoStart autoStart) {
        this.autoStart = autoStart;
    }

    public ConversationAppSettings markdown(Markdown markdown) {
        this.markdown = markdown;
        return this;
    }

    @ApiModelProperty(example="null", value="The markdown for the messenger app")
    @JsonProperty(value="markdown")
    public Markdown getMarkdown() {
        return this.markdown;
    }

    public void setMarkdown(Markdown markdown) {
        this.markdown = markdown;
    }

    public ConversationAppSettings conversationDisconnect(ConversationDisconnectSettings conversationDisconnect) {
        this.conversationDisconnect = conversationDisconnect;
        return this;
    }

    @ApiModelProperty(example="null", value="The conversation disconnect settings for the messenger app")
    @JsonProperty(value="conversationDisconnect")
    public ConversationDisconnectSettings getConversationDisconnect() {
        return this.conversationDisconnect;
    }

    public void setConversationDisconnect(ConversationDisconnectSettings conversationDisconnect) {
        this.conversationDisconnect = conversationDisconnect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationAppSettings conversationAppSettings = (ConversationAppSettings)o;
        return Objects.equals(this.showAgentTypingIndicator, conversationAppSettings.showAgentTypingIndicator) && Objects.equals(this.showUserTypingIndicator, conversationAppSettings.showUserTypingIndicator) && Objects.equals((Object)this.autoStartType, (Object)conversationAppSettings.autoStartType) && Objects.equals(this.autoStart, conversationAppSettings.autoStart) && Objects.equals(this.markdown, conversationAppSettings.markdown) && Objects.equals(this.conversationDisconnect, conversationAppSettings.conversationDisconnect);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.showAgentTypingIndicator, this.showUserTypingIndicator, this.autoStartType, this.autoStart, this.markdown, this.conversationDisconnect});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationAppSettings {\n");
        sb.append("    showAgentTypingIndicator: ").append(this.toIndentedString(this.showAgentTypingIndicator)).append("\n");
        sb.append("    showUserTypingIndicator: ").append(this.toIndentedString(this.showUserTypingIndicator)).append("\n");
        sb.append("    autoStartType: ").append(this.toIndentedString((Object)this.autoStartType)).append("\n");
        sb.append("    autoStart: ").append(this.toIndentedString(this.autoStart)).append("\n");
        sb.append("    markdown: ").append(this.toIndentedString(this.markdown)).append("\n");
        sb.append("    conversationDisconnect: ").append(this.toIndentedString(this.conversationDisconnect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AutoStartTypeEnumDeserializer.class)
    public static enum AutoStartTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STANDARD("Standard"),
        AUTOMATIC("Automatic");

        private String value;

        private AutoStartTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoStartTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoStartTypeEnum value : AutoStartTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoStartTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoStartTypeEnumDeserializer
    extends StdDeserializer<AutoStartTypeEnum> {
        public AutoStartTypeEnumDeserializer() {
            super(AutoStartTypeEnumDeserializer.class);
        }

        public AutoStartTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoStartTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

