/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.UserRoutingSkill;
import java.util.HashMap;
import java.util.Map;

public class PutUserRoutingskillRequest {
    private String userId;
    private String skillId;
    private UserRoutingSkill body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PutUserRoutingskillRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getSkillId() {
        return this.skillId;
    }

    public void setSkillId(String skillId) {
        this.skillId = skillId;
    }

    public PutUserRoutingskillRequest withSkillId(String skillId) {
        this.setSkillId(skillId);
        return this;
    }

    public UserRoutingSkill getBody() {
        return this.body;
    }

    public void setBody(UserRoutingSkill body) {
        this.body = body;
    }

    public PutUserRoutingskillRequest withBody(UserRoutingSkill body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutUserRoutingskillRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<UserRoutingSkill> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutUserRoutingskillRequest.");
        }
        if (this.skillId == null) {
            throw new IllegalStateException("Missing the required parameter 'skillId' when building request for PutUserRoutingskillRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserRoutingskillRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/users/{userId}/routingskills/{skillId}").withPathParameter("userId", this.userId).withPathParameter("skillId", this.skillId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String skillId, UserRoutingSkill body) {
        return new Builder().withRequiredParams(userId, skillId, body);
    }

    public static class Builder {
        private final PutUserRoutingskillRequest request = new PutUserRoutingskillRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withSkillId(String skillId) {
            this.request.setSkillId(skillId);
            return this;
        }

        public Builder withBody(UserRoutingSkill body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String userId, String skillId, UserRoutingSkill body) {
            this.request.setUserId(userId);
            this.request.setSkillId(skillId);
            this.request.setBody(body);
            return this;
        }

        public PutUserRoutingskillRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PutUserRoutingskillRequest.");
            }
            if (this.request.skillId == null) {
                throw new IllegalStateException("Missing the required parameter 'skillId' when building request for PutUserRoutingskillRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutUserRoutingskillRequest.");
            }
            return this.request;
        }
    }
}

