/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.PostKnowledgeDocumentuploadsRequest;
import com.mypurecloud.sdk.v2.api.request.PostLanguageunderstandingMinerUploadsRequest;
import com.mypurecloud.sdk.v2.api.request.PostUploadsPublicassetsImagesRequest;
import com.mypurecloud.sdk.v2.api.request.PostUploadsRecordingsRequest;
import com.mypurecloud.sdk.v2.api.request.PostUploadsWorkforcemanagementHistoricaldataCsvRequest;
import com.mypurecloud.sdk.v2.model.UploadUrlRequest;
import com.mypurecloud.sdk.v2.model.UploadUrlResponse;
import java.io.IOException;

public class UploadsApi {
    private final ApiClient pcapiClient;

    public UploadsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UploadsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public UploadUrlResponse postKnowledgeDocumentuploads(UploadUrlRequest body) throws IOException, ApiException {
        return this.postKnowledgeDocumentuploads(this.createPostKnowledgeDocumentuploadsRequest(body));
    }

    public ApiResponse<UploadUrlResponse> postKnowledgeDocumentuploadsWithHttpInfo(UploadUrlRequest body) throws IOException {
        return this.postKnowledgeDocumentuploads(this.createPostKnowledgeDocumentuploadsRequest(body).withHttpInfo());
    }

    private PostKnowledgeDocumentuploadsRequest createPostKnowledgeDocumentuploadsRequest(UploadUrlRequest body) {
        return PostKnowledgeDocumentuploadsRequest.builder().withBody(body).build();
    }

    public UploadUrlResponse postKnowledgeDocumentuploads(PostKnowledgeDocumentuploadsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UploadUrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UploadUrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UploadUrlResponse> postKnowledgeDocumentuploads(ApiRequest<UploadUrlRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UploadUrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UploadUrlResponse postLanguageunderstandingMinerUploads(String minerId, Object body) throws IOException, ApiException {
        return this.postLanguageunderstandingMinerUploads(this.createPostLanguageunderstandingMinerUploadsRequest(minerId, body));
    }

    public ApiResponse<UploadUrlResponse> postLanguageunderstandingMinerUploadsWithHttpInfo(String minerId, Object body) throws IOException {
        return this.postLanguageunderstandingMinerUploads(this.createPostLanguageunderstandingMinerUploadsRequest(minerId, body).withHttpInfo());
    }

    private PostLanguageunderstandingMinerUploadsRequest createPostLanguageunderstandingMinerUploadsRequest(String minerId, Object body) {
        return PostLanguageunderstandingMinerUploadsRequest.builder().withMinerId(minerId).withBody(body).build();
    }

    public UploadUrlResponse postLanguageunderstandingMinerUploads(PostLanguageunderstandingMinerUploadsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UploadUrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UploadUrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UploadUrlResponse> postLanguageunderstandingMinerUploads(ApiRequest<Object> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UploadUrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UploadUrlResponse postUploadsPublicassetsImages(UploadUrlRequest body) throws IOException, ApiException {
        return this.postUploadsPublicassetsImages(this.createPostUploadsPublicassetsImagesRequest(body));
    }

    public ApiResponse<UploadUrlResponse> postUploadsPublicassetsImagesWithHttpInfo(UploadUrlRequest body) throws IOException {
        return this.postUploadsPublicassetsImages(this.createPostUploadsPublicassetsImagesRequest(body).withHttpInfo());
    }

    private PostUploadsPublicassetsImagesRequest createPostUploadsPublicassetsImagesRequest(UploadUrlRequest body) {
        return PostUploadsPublicassetsImagesRequest.builder().withBody(body).build();
    }

    public UploadUrlResponse postUploadsPublicassetsImages(PostUploadsPublicassetsImagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UploadUrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UploadUrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UploadUrlResponse> postUploadsPublicassetsImages(ApiRequest<UploadUrlRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UploadUrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UploadUrlResponse postUploadsRecordings(UploadUrlRequest body) throws IOException, ApiException {
        return this.postUploadsRecordings(this.createPostUploadsRecordingsRequest(body));
    }

    public ApiResponse<UploadUrlResponse> postUploadsRecordingsWithHttpInfo(UploadUrlRequest body) throws IOException {
        return this.postUploadsRecordings(this.createPostUploadsRecordingsRequest(body).withHttpInfo());
    }

    private PostUploadsRecordingsRequest createPostUploadsRecordingsRequest(UploadUrlRequest body) {
        return PostUploadsRecordingsRequest.builder().withBody(body).build();
    }

    public UploadUrlResponse postUploadsRecordings(PostUploadsRecordingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UploadUrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UploadUrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UploadUrlResponse> postUploadsRecordings(ApiRequest<UploadUrlRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UploadUrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UploadUrlResponse postUploadsWorkforcemanagementHistoricaldataCsv(UploadUrlRequest body) throws IOException, ApiException {
        return this.postUploadsWorkforcemanagementHistoricaldataCsv(this.createPostUploadsWorkforcemanagementHistoricaldataCsvRequest(body));
    }

    public ApiResponse<UploadUrlResponse> postUploadsWorkforcemanagementHistoricaldataCsvWithHttpInfo(UploadUrlRequest body) throws IOException {
        return this.postUploadsWorkforcemanagementHistoricaldataCsv(this.createPostUploadsWorkforcemanagementHistoricaldataCsvRequest(body).withHttpInfo());
    }

    private PostUploadsWorkforcemanagementHistoricaldataCsvRequest createPostUploadsWorkforcemanagementHistoricaldataCsvRequest(UploadUrlRequest body) {
        return PostUploadsWorkforcemanagementHistoricaldataCsvRequest.builder().withBody(body).build();
    }

    public UploadUrlResponse postUploadsWorkforcemanagementHistoricaldataCsv(PostUploadsWorkforcemanagementHistoricaldataCsvRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UploadUrlResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UploadUrlResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UploadUrlResponse> postUploadsWorkforcemanagementHistoricaldataCsv(ApiRequest<UploadUrlRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UploadUrlResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

