/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetFlowRequest {
    private String flowId;
    private Boolean deleted;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public GetFlowRequest withFlowId(String flowId) {
        this.setFlowId(flowId);
        return this;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public GetFlowRequest withDeleted(Boolean deleted) {
        this.setDeleted(deleted);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetFlowRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.flowId == null) {
            throw new IllegalStateException("Missing the required parameter 'flowId' when building request for GetFlowRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/flows/{flowId}").withPathParameter("flowId", this.flowId).withQueryParameters("deleted", "", this.deleted).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String flowId) {
        return new Builder().withRequiredParams(flowId);
    }

    public static class Builder {
        private final GetFlowRequest request = new GetFlowRequest();

        private Builder() {
        }

        public Builder withFlowId(String flowId) {
            this.request.setFlowId(flowId);
            return this;
        }

        public Builder withDeleted(Boolean deleted) {
            this.request.setDeleted(deleted);
            return this;
        }

        public Builder withRequiredParams(String flowId) {
            this.request.setFlowId(flowId);
            return this;
        }

        public GetFlowRequest build() {
            if (this.request.flowId == null) {
                throw new IllegalStateException("Missing the required parameter 'flowId' when building request for GetFlowRequest.");
            }
            return this.request;
        }
    }
}

