/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ParticipantAttributes;
import java.util.HashMap;
import java.util.Map;

public class PatchConversationsEmailParticipantAttributesRequest {
    private String conversationId;
    private String participantId;
    private ParticipantAttributes body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PatchConversationsEmailParticipantAttributesRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsEmailParticipantAttributesRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public ParticipantAttributes getBody() {
        return this.body;
    }

    public void setBody(ParticipantAttributes body) {
        this.body = body;
    }

    public PatchConversationsEmailParticipantAttributesRequest withBody(ParticipantAttributes body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsEmailParticipantAttributesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ParticipantAttributes> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchConversationsEmailParticipantAttributesRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsEmailParticipantAttributesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailParticipantAttributesRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/emails/{conversationId}/participants/{participantId}/attributes").withPathParameter("conversationId", this.conversationId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String participantId, ParticipantAttributes body) {
        return new Builder().withRequiredParams(conversationId, participantId, body);
    }

    public static class Builder {
        private final PatchConversationsEmailParticipantAttributesRequest request = new PatchConversationsEmailParticipantAttributesRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(ParticipantAttributes body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String participantId, ParticipantAttributes body) {
            this.request.setConversationId(conversationId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsEmailParticipantAttributesRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchConversationsEmailParticipantAttributesRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsEmailParticipantAttributesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailParticipantAttributesRequest.");
            }
            return this.request;
        }
    }
}

