/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CreateMetric;
import java.util.HashMap;
import java.util.Map;

public class PutGamificationProfileMetricRequest {
    private String profileId;
    private String metricId;
    private CreateMetric body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String profileId) {
        this.profileId = profileId;
    }

    public PutGamificationProfileMetricRequest withProfileId(String profileId) {
        this.setProfileId(profileId);
        return this;
    }

    public String getMetricId() {
        return this.metricId;
    }

    public void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    public PutGamificationProfileMetricRequest withMetricId(String metricId) {
        this.setMetricId(metricId);
        return this;
    }

    public CreateMetric getBody() {
        return this.body;
    }

    public void setBody(CreateMetric body) {
        this.body = body;
    }

    public PutGamificationProfileMetricRequest withBody(CreateMetric body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutGamificationProfileMetricRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CreateMetric> withHttpInfo() {
        if (this.profileId == null) {
            throw new IllegalStateException("Missing the required parameter 'profileId' when building request for PutGamificationProfileMetricRequest.");
        }
        if (this.metricId == null) {
            throw new IllegalStateException("Missing the required parameter 'metricId' when building request for PutGamificationProfileMetricRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGamificationProfileMetricRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/gamification/profiles/{profileId}/metrics/{metricId}").withPathParameter("profileId", this.profileId).withPathParameter("metricId", this.metricId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String profileId, String metricId, CreateMetric body) {
        return new Builder().withRequiredParams(profileId, metricId, body);
    }

    public static class Builder {
        private final PutGamificationProfileMetricRequest request = new PutGamificationProfileMetricRequest();

        private Builder() {
        }

        public Builder withProfileId(String profileId) {
            this.request.setProfileId(profileId);
            return this;
        }

        public Builder withMetricId(String metricId) {
            this.request.setMetricId(metricId);
            return this;
        }

        public Builder withBody(CreateMetric body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String profileId, String metricId, CreateMetric body) {
            this.request.setProfileId(profileId);
            this.request.setMetricId(metricId);
            this.request.setBody(body);
            return this;
        }

        public PutGamificationProfileMetricRequest build() {
            if (this.request.profileId == null) {
                throw new IllegalStateException("Missing the required parameter 'profileId' when building request for PutGamificationProfileMetricRequest.");
            }
            if (this.request.metricId == null) {
                throw new IllegalStateException("Missing the required parameter 'metricId' when building request for PutGamificationProfileMetricRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGamificationProfileMetricRequest.");
            }
            return this.request;
        }
    }
}

