/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class RequestMapping
implements Serializable {
    private String name = null;
    private AttributeTypeEnum attributeType = null;
    private MappingTypeEnum mappingType = null;
    private String value = null;

    public RequestMapping name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the Integration Action Attribute to supply the value for")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RequestMapping attributeType(AttributeTypeEnum attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the value supplied")
    @JsonProperty(value="attributeType")
    public AttributeTypeEnum getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeTypeEnum attributeType) {
        this.attributeType = attributeType;
    }

    public RequestMapping mappingType(MappingTypeEnum mappingType) {
        this.mappingType = mappingType;
        return this;
    }

    @ApiModelProperty(example="null", value="Method of finding value to use with Attribute")
    @JsonProperty(value="mappingType")
    public MappingTypeEnum getMappingType() {
        return this.mappingType;
    }

    public void setMappingType(MappingTypeEnum mappingType) {
        this.mappingType = mappingType;
    }

    public RequestMapping value(String value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="null", value="Value to supply for the specified Attribute")
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestMapping requestMapping = (RequestMapping)o;
        return Objects.equals(this.name, requestMapping.name) && Objects.equals((Object)this.attributeType, (Object)requestMapping.attributeType) && Objects.equals((Object)this.mappingType, (Object)requestMapping.mappingType) && Objects.equals(this.value, requestMapping.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.attributeType, this.mappingType, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RequestMapping {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    attributeType: ").append(this.toIndentedString((Object)this.attributeType)).append("\n");
        sb.append("    mappingType: ").append(this.toIndentedString((Object)this.mappingType)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MappingTypeEnumDeserializer.class)
    public static enum MappingTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LOOKUP("Lookup"),
        HARDCODED("HardCoded");

        private String value;

        private MappingTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MappingTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MappingTypeEnum value : MappingTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MappingTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MappingTypeEnumDeserializer
    extends StdDeserializer<MappingTypeEnum> {
        public MappingTypeEnumDeserializer() {
            super(MappingTypeEnumDeserializer.class);
        }

        public MappingTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MappingTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=AttributeTypeEnumDeserializer.class)
    public static enum AttributeTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        STRING("String"),
        NUMBER("Number"),
        INTEGER("Integer"),
        BOOLEAN("Boolean");

        private String value;

        private AttributeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttributeTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AttributeTypeEnum value : AttributeTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AttributeTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AttributeTypeEnumDeserializer
    extends StdDeserializer<AttributeTypeEnum> {
        public AttributeTypeEnumDeserializer() {
            super(AttributeTypeEnumDeserializer.class);
        }

        public AttributeTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AttributeTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

