/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.UserReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CreateAdminTimeOffRequest
implements Serializable {
    private StatusEnum status = null;
    private List<UserReference> users = new ArrayList<UserReference>();
    private String activityCodeId = null;
    private String notes = null;
    private List<String> fullDayManagementUnitDates = new ArrayList<String>();
    private List<Date> partialDayStartDateTimes = new ArrayList<Date>();
    private Integer dailyDurationMinutes = null;

    public CreateAdminTimeOffRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of this time off request")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CreateAdminTimeOffRequest users(List<UserReference> users) {
        this.users = users;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A set of IDs for users to associate with this time off request")
    @JsonProperty(value="users")
    public List<UserReference> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserReference> users) {
        this.users = users;
    }

    public CreateAdminTimeOffRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the activity code associated with this time off request. Activity code must be of the TimeOff category")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public CreateAdminTimeOffRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Notes about the time off request")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateAdminTimeOffRequest fullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.")
    @JsonProperty(value="fullDayManagementUnitDates")
    public List<String> getFullDayManagementUnitDates() {
        return this.fullDayManagementUnitDates;
    }

    public void setFullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
    }

    public CreateAdminTimeOffRequest partialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of start date-times in ISO-8601 format for partial day requests.")
    @JsonProperty(value="partialDayStartDateTimes")
    public List<Date> getPartialDayStartDateTimes() {
        return this.partialDayStartDateTimes;
    }

    public void setPartialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
    }

    public CreateAdminTimeOffRequest dailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The daily duration of this time off request in minutes")
    @JsonProperty(value="dailyDurationMinutes")
    public Integer getDailyDurationMinutes() {
        return this.dailyDurationMinutes;
    }

    public void setDailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAdminTimeOffRequest createAdminTimeOffRequest = (CreateAdminTimeOffRequest)o;
        return Objects.equals((Object)this.status, (Object)createAdminTimeOffRequest.status) && Objects.equals(this.users, createAdminTimeOffRequest.users) && Objects.equals(this.activityCodeId, createAdminTimeOffRequest.activityCodeId) && Objects.equals(this.notes, createAdminTimeOffRequest.notes) && Objects.equals(this.fullDayManagementUnitDates, createAdminTimeOffRequest.fullDayManagementUnitDates) && Objects.equals(this.partialDayStartDateTimes, createAdminTimeOffRequest.partialDayStartDateTimes) && Objects.equals(this.dailyDurationMinutes, createAdminTimeOffRequest.dailyDurationMinutes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.users, this.activityCodeId, this.notes, this.fullDayManagementUnitDates, this.partialDayStartDateTimes, this.dailyDurationMinutes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAdminTimeOffRequest {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    fullDayManagementUnitDates: ").append(this.toIndentedString(this.fullDayManagementUnitDates)).append("\n");
        sb.append("    partialDayStartDateTimes: ").append(this.toIndentedString(this.partialDayStartDateTimes)).append("\n");
        sb.append("    dailyDurationMinutes: ").append(this.toIndentedString(this.dailyDurationMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("PENDING"),
        APPROVED("APPROVED");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

