/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CoachingAnnotationCreateRequest;
import java.util.HashMap;
import java.util.Map;

public class PostCoachingAppointmentAnnotationsRequest {
    private String appointmentId;
    private CoachingAnnotationCreateRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public PostCoachingAppointmentAnnotationsRequest withAppointmentId(String appointmentId) {
        this.setAppointmentId(appointmentId);
        return this;
    }

    public CoachingAnnotationCreateRequest getBody() {
        return this.body;
    }

    public void setBody(CoachingAnnotationCreateRequest body) {
        this.body = body;
    }

    public PostCoachingAppointmentAnnotationsRequest withBody(CoachingAnnotationCreateRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostCoachingAppointmentAnnotationsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CoachingAnnotationCreateRequest> withHttpInfo() {
        if (this.appointmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PostCoachingAppointmentAnnotationsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostCoachingAppointmentAnnotationsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/coaching/appointments/{appointmentId}/annotations").withPathParameter("appointmentId", this.appointmentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String appointmentId, CoachingAnnotationCreateRequest body) {
        return new Builder().withRequiredParams(appointmentId, body);
    }

    public static class Builder {
        private final PostCoachingAppointmentAnnotationsRequest request = new PostCoachingAppointmentAnnotationsRequest();

        private Builder() {
        }

        public Builder withAppointmentId(String appointmentId) {
            this.request.setAppointmentId(appointmentId);
            return this;
        }

        public Builder withBody(CoachingAnnotationCreateRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String appointmentId, CoachingAnnotationCreateRequest body) {
            this.request.setAppointmentId(appointmentId);
            this.request.setBody(body);
            return this;
        }

        public PostCoachingAppointmentAnnotationsRequest build() {
            if (this.request.appointmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PostCoachingAppointmentAnnotationsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostCoachingAppointmentAnnotationsRequest.");
            }
            return this.request;
        }
    }
}

