/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.StatusChange;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class LimitChangeRequestDetails
implements Serializable {
    private String id = null;
    private String key = null;
    private String namespace = null;
    private Double requestedValue = null;
    private String description = null;
    private String supportCaseUrl = null;
    private String createdBy = null;
    private StatusEnum status = null;
    private Double currentValue = null;
    private Date dateCreated = null;
    private List<StatusChange> statusHistory = new ArrayList<StatusChange>();
    private Date dateCompleted = null;
    private String lastChangedBy = null;
    private RejectReasonEnum rejectReason = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public LimitChangeRequestDetails key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Limit key to be overridden (see https://developer.mypurecloud.com/api/rest/v2/organization/limits.html#available_limits)")
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public LimitChangeRequestDetails namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Namespace the key belongs to (see https://developer.mypurecloud.com/api/rest/v2/organization/limits.html#available_limits)")
    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public LimitChangeRequestDetails requestedValue(Double requestedValue) {
        this.requestedValue = requestedValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Requested limit value for a given key")
    @JsonProperty(value="requestedValue")
    public Double getRequestedValue() {
        return this.requestedValue;
    }

    public void setRequestedValue(Double requestedValue) {
        this.requestedValue = requestedValue;
    }

    public LimitChangeRequestDetails description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Description of the need for the limit change request")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LimitChangeRequestDetails supportCaseUrl(String supportCaseUrl) {
        this.supportCaseUrl = supportCaseUrl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The support case url created by Care")
    @JsonProperty(value="supportCaseUrl")
    public String getSupportCaseUrl() {
        return this.supportCaseUrl;
    }

    public void setSupportCaseUrl(String supportCaseUrl) {
        this.supportCaseUrl = supportCaseUrl;
    }

    @ApiModelProperty(example="null", value="The user who created the change request")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="Current status of the limit change request")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Current limit value for a given key")
    @JsonProperty(value="currentValue")
    public Double getCurrentValue() {
        return this.currentValue;
    }

    @ApiModelProperty(example="null", value="The date of the limit change request creation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="List of statuses that a limit change request has gone through")
    @JsonProperty(value="statusHistory")
    public List<StatusChange> getStatusHistory() {
        return this.statusHistory;
    }

    @ApiModelProperty(example="null", value="The date of the limit change request completion (ChangeImplemented, Rejected, or RollbackImplemented. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    @ApiModelProperty(example="null", value="The user who last updated the status of the limit change request")
    @JsonProperty(value="lastChangedBy")
    public String getLastChangedBy() {
        return this.lastChangedBy;
    }

    @ApiModelProperty(example="null", value="The reason for rejecting the limit override request")
    @JsonProperty(value="rejectReason")
    public RejectReasonEnum getRejectReason() {
        return this.rejectReason;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitChangeRequestDetails limitChangeRequestDetails = (LimitChangeRequestDetails)o;
        return Objects.equals(this.id, limitChangeRequestDetails.id) && Objects.equals(this.key, limitChangeRequestDetails.key) && Objects.equals(this.namespace, limitChangeRequestDetails.namespace) && Objects.equals(this.requestedValue, limitChangeRequestDetails.requestedValue) && Objects.equals(this.description, limitChangeRequestDetails.description) && Objects.equals(this.supportCaseUrl, limitChangeRequestDetails.supportCaseUrl) && Objects.equals(this.createdBy, limitChangeRequestDetails.createdBy) && Objects.equals((Object)this.status, (Object)limitChangeRequestDetails.status) && Objects.equals(this.currentValue, limitChangeRequestDetails.currentValue) && Objects.equals(this.dateCreated, limitChangeRequestDetails.dateCreated) && Objects.equals(this.statusHistory, limitChangeRequestDetails.statusHistory) && Objects.equals(this.dateCompleted, limitChangeRequestDetails.dateCompleted) && Objects.equals(this.lastChangedBy, limitChangeRequestDetails.lastChangedBy) && Objects.equals((Object)this.rejectReason, (Object)limitChangeRequestDetails.rejectReason) && Objects.equals(this.selfUri, limitChangeRequestDetails.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.namespace, this.requestedValue, this.description, this.supportCaseUrl, this.createdBy, this.status, this.currentValue, this.dateCreated, this.statusHistory, this.dateCompleted, this.lastChangedBy, this.rejectReason, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LimitChangeRequestDetails {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    requestedValue: ").append(this.toIndentedString(this.requestedValue)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    supportCaseUrl: ").append(this.toIndentedString(this.supportCaseUrl)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    currentValue: ").append(this.toIndentedString(this.currentValue)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    statusHistory: ").append(this.toIndentedString(this.statusHistory)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    lastChangedBy: ").append(this.toIndentedString(this.lastChangedBy)).append("\n");
        sb.append("    rejectReason: ").append(this.toIndentedString((Object)this.rejectReason)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RejectReasonEnumDeserializer.class)
    public static enum RejectReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALTERNATIVEEXISTS("AlternativeExists"),
        INCREASENOTREQUIRED("IncreaseNotRequired"),
        PLATFORMMISUSE("PlatformMisuse"),
        PLATFORMSTABILITY("PlatformStability"),
        OTHERREASON("OtherReason");

        private String value;

        private RejectReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RejectReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RejectReasonEnum value : RejectReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RejectReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RejectReasonEnumDeserializer
    extends StdDeserializer<RejectReasonEnum> {
        public RejectReasonEnumDeserializer() {
            super(RejectReasonEnumDeserializer.class);
        }

        public RejectReasonEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RejectReasonEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPEN("Open"),
        APPROVED("Approved"),
        IMPLEMENTINGCHANGE("ImplementingChange"),
        CHANGEIMPLEMENTED("ChangeImplemented"),
        REJECTED("Rejected"),
        ROLLBACK("Rollback"),
        IMPLEMENTINGROLLBACK("ImplementingRollback"),
        ROLLBACKIMPLEMENTED("RollbackImplemented");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

