/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AssessmentForm;
import com.mypurecloud.sdk.v2.model.LearningModuleInformStepRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning module request")
public class LearningModuleRequest
implements Serializable {
    private String name = null;
    private String description = null;
    private Integer completionTimeInDays = null;
    private List<LearningModuleInformStepRequest> informSteps = new ArrayList<LearningModuleInformStepRequest>();
    private TypeEnum type = null;
    private AssessmentForm assessmentForm = null;

    public LearningModuleRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of learning module")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LearningModuleRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of learning module")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LearningModuleRequest completionTimeInDays(Integer completionTimeInDays) {
        this.completionTimeInDays = completionTimeInDays;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The completion time of learning module in days")
    @JsonProperty(value="completionTimeInDays")
    public Integer getCompletionTimeInDays() {
        return this.completionTimeInDays;
    }

    public void setCompletionTimeInDays(Integer completionTimeInDays) {
        this.completionTimeInDays = completionTimeInDays;
    }

    public LearningModuleRequest informSteps(List<LearningModuleInformStepRequest> informSteps) {
        this.informSteps = informSteps;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of inform steps in a learning module")
    @JsonProperty(value="informSteps")
    public List<LearningModuleInformStepRequest> getInformSteps() {
        return this.informSteps;
    }

    public void setInformSteps(List<LearningModuleInformStepRequest> informSteps) {
        this.informSteps = informSteps;
    }

    public LearningModuleRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type for the learning module")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public LearningModuleRequest assessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
        return this;
    }

    @ApiModelProperty(example="null", value="The assessment form for learning module")
    @JsonProperty(value="assessmentForm")
    public AssessmentForm getAssessmentForm() {
        return this.assessmentForm;
    }

    public void setAssessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningModuleRequest learningModuleRequest = (LearningModuleRequest)o;
        return Objects.equals(this.name, learningModuleRequest.name) && Objects.equals(this.description, learningModuleRequest.description) && Objects.equals(this.completionTimeInDays, learningModuleRequest.completionTimeInDays) && Objects.equals(this.informSteps, learningModuleRequest.informSteps) && Objects.equals((Object)this.type, (Object)learningModuleRequest.type) && Objects.equals(this.assessmentForm, learningModuleRequest.assessmentForm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.completionTimeInDays, this.informSteps, this.type, this.assessmentForm});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningModuleRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    completionTimeInDays: ").append(this.toIndentedString(this.completionTimeInDays)).append("\n");
        sb.append("    informSteps: ").append(this.toIndentedString(this.informSteps)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    assessmentForm: ").append(this.toIndentedString(this.assessmentForm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INFORMATIONAL("Informational"),
        ASSESSEDCONTENT("AssessedContent"),
        ASSESSMENT("Assessment");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

