/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Greeting;
import java.util.HashMap;
import java.util.Map;

public class PutGreetingRequest {
    private String greetingId;
    private Greeting body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGreetingId() {
        return this.greetingId;
    }

    public void setGreetingId(String greetingId) {
        this.greetingId = greetingId;
    }

    public PutGreetingRequest withGreetingId(String greetingId) {
        this.setGreetingId(greetingId);
        return this;
    }

    public Greeting getBody() {
        return this.body;
    }

    public void setBody(Greeting body) {
        this.body = body;
    }

    public PutGreetingRequest withBody(Greeting body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutGreetingRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Greeting> withHttpInfo() {
        if (this.greetingId == null) {
            throw new IllegalStateException("Missing the required parameter 'greetingId' when building request for PutGreetingRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGreetingRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/greetings/{greetingId}").withPathParameter("greetingId", this.greetingId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String greetingId, Greeting body) {
        return new Builder().withRequiredParams(greetingId, body);
    }

    public static class Builder {
        private final PutGreetingRequest request = new PutGreetingRequest();

        private Builder() {
        }

        public Builder withGreetingId(String greetingId) {
            this.request.setGreetingId(greetingId);
            return this;
        }

        public Builder withBody(Greeting body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String greetingId, Greeting body) {
            this.request.setGreetingId(greetingId);
            this.request.setBody(body);
            return this;
        }

        public PutGreetingRequest build() {
            if (this.request.greetingId == null) {
                throw new IllegalStateException("Missing the required parameter 'greetingId' when building request for PutGreetingRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutGreetingRequest.");
            }
            return this.request;
        }
    }
}

