/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class OpenIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private String outboundNotificationWebhookUrl = null;
    private String outboundNotificationWebhookSignatureSecretToken = null;
    private Map<String, String> webhookHeaders = null;
    private String status = null;
    private DomainEntityRef recipient = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private CreateStatusEnum createStatus = null;
    private ErrorBody createError = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", required=true, value="A unique Integration Id.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OpenIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Open messaging integration.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public OpenIntegration outboundNotificationWebhookUrl(String outboundNotificationWebhookUrl) {
        this.outboundNotificationWebhookUrl = outboundNotificationWebhookUrl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The outbound notification webhook URL for the Open messaging integration.")
    @JsonProperty(value="outboundNotificationWebhookUrl")
    public String getOutboundNotificationWebhookUrl() {
        return this.outboundNotificationWebhookUrl;
    }

    public void setOutboundNotificationWebhookUrl(String outboundNotificationWebhookUrl) {
        this.outboundNotificationWebhookUrl = outboundNotificationWebhookUrl;
    }

    public OpenIntegration outboundNotificationWebhookSignatureSecretToken(String outboundNotificationWebhookSignatureSecretToken) {
        this.outboundNotificationWebhookSignatureSecretToken = outboundNotificationWebhookSignatureSecretToken;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The outbound notification webhook signature secret token.")
    @JsonProperty(value="outboundNotificationWebhookSignatureSecretToken")
    public String getOutboundNotificationWebhookSignatureSecretToken() {
        return this.outboundNotificationWebhookSignatureSecretToken;
    }

    public void setOutboundNotificationWebhookSignatureSecretToken(String outboundNotificationWebhookSignatureSecretToken) {
        this.outboundNotificationWebhookSignatureSecretToken = outboundNotificationWebhookSignatureSecretToken;
    }

    public OpenIntegration webhookHeaders(Map<String, String> webhookHeaders) {
        this.webhookHeaders = webhookHeaders;
        return this;
    }

    @ApiModelProperty(example="null", value="The user specified headers for the Open messaging integration.")
    @JsonProperty(value="webhookHeaders")
    public Map<String, String> getWebhookHeaders() {
        return this.webhookHeaders;
    }

    public void setWebhookHeaders(Map<String, String> webhookHeaders) {
        this.webhookHeaders = webhookHeaders;
    }

    public OpenIntegration status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the Open Integration")
    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @ApiModelProperty(example="null", value="The recipient associated to the Open messaging Integration. This recipient is used to associate a flow to an integration")
    @JsonProperty(value="recipient")
    public DomainEntityRef getRecipient() {
        return this.recipient;
    }

    public OpenIntegration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public OpenIntegration dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public OpenIntegration createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that created this Integration")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public OpenIntegration modifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that last modified this Integration")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @ApiModelProperty(example="null", value="Status of asynchronous create operation")
    @JsonProperty(value="createStatus")
    public CreateStatusEnum getCreateStatus() {
        return this.createStatus;
    }

    @ApiModelProperty(example="null", value="Error information returned, if createStatus is set to Error")
    @JsonProperty(value="createError")
    public ErrorBody getCreateError() {
        return this.createError;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIntegration openIntegration = (OpenIntegration)o;
        return Objects.equals(this.id, openIntegration.id) && Objects.equals(this.name, openIntegration.name) && Objects.equals(this.outboundNotificationWebhookUrl, openIntegration.outboundNotificationWebhookUrl) && Objects.equals(this.outboundNotificationWebhookSignatureSecretToken, openIntegration.outboundNotificationWebhookSignatureSecretToken) && Objects.equals(this.webhookHeaders, openIntegration.webhookHeaders) && Objects.equals(this.status, openIntegration.status) && Objects.equals(this.recipient, openIntegration.recipient) && Objects.equals(this.dateCreated, openIntegration.dateCreated) && Objects.equals(this.dateModified, openIntegration.dateModified) && Objects.equals(this.createdBy, openIntegration.createdBy) && Objects.equals(this.modifiedBy, openIntegration.modifiedBy) && Objects.equals((Object)this.createStatus, (Object)openIntegration.createStatus) && Objects.equals(this.createError, openIntegration.createError) && Objects.equals(this.selfUri, openIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.outboundNotificationWebhookUrl, this.outboundNotificationWebhookSignatureSecretToken, this.webhookHeaders, this.status, this.recipient, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.createStatus, this.createError, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    outboundNotificationWebhookUrl: ").append(this.toIndentedString(this.outboundNotificationWebhookUrl)).append("\n");
        sb.append("    outboundNotificationWebhookSignatureSecretToken: ").append(this.toIndentedString(this.outboundNotificationWebhookSignatureSecretToken)).append("\n");
        sb.append("    webhookHeaders: ").append(this.toIndentedString(this.webhookHeaders)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createStatus: ").append(this.toIndentedString((Object)this.createStatus)).append("\n");
        sb.append("    createError: ").append(this.toIndentedString(this.createError)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CreateStatusEnumDeserializer.class)
    public static enum CreateStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INITIATED("Initiated"),
        COMPLETED("Completed"),
        ERROR("Error");

        private String value;

        private CreateStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreateStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CreateStatusEnum value : CreateStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CreateStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CreateStatusEnumDeserializer
    extends StdDeserializer<CreateStatusEnum> {
        public CreateStatusEnumDeserializer() {
            super(CreateStatusEnumDeserializer.class);
        }

        public CreateStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CreateStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

