/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="User actions available on the content. All actions are optional and all actions are executed simultaneously.")
public class ContentActions
implements Serializable {
    private String url = null;
    private String urlTarget = null;
    private String textback = null;

    public ContentActions url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="null", value="A URL of a web page to direct the user to.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ContentActions urlTarget(String urlTarget) {
        this.urlTarget = urlTarget;
        return this;
    }

    @ApiModelProperty(example="null", value="The target window in which to open the URL. If empty will open a blank page or tab.")
    @JsonProperty(value="urlTarget")
    public String getUrlTarget() {
        return this.urlTarget;
    }

    public void setUrlTarget(String urlTarget) {
        this.urlTarget = urlTarget;
    }

    public ContentActions textback(String textback) {
        this.textback = textback;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to be sent back in reply when the item is selected.")
    @JsonProperty(value="textback")
    public String getTextback() {
        return this.textback;
    }

    public void setTextback(String textback) {
        this.textback = textback;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentActions contentActions = (ContentActions)o;
        return Objects.equals(this.url, contentActions.url) && Objects.equals(this.urlTarget, contentActions.urlTarget) && Objects.equals(this.textback, contentActions.textback);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.urlTarget, this.textback);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentActions {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    urlTarget: ").append(this.toIndentedString(this.urlTarget)).append("\n");
        sb.append("    textback: ").append(this.toIndentedString(this.textback)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

