/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CreateWebChatMessageRequest;
import java.util.HashMap;
import java.util.Map;

public class PostConversationsChatCommunicationMessagesRequest {
    private String conversationId;
    private String communicationId;
    private CreateWebChatMessageRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PostConversationsChatCommunicationMessagesRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public String getCommunicationId() {
        return this.communicationId;
    }

    public void setCommunicationId(String communicationId) {
        this.communicationId = communicationId;
    }

    public PostConversationsChatCommunicationMessagesRequest withCommunicationId(String communicationId) {
        this.setCommunicationId(communicationId);
        return this;
    }

    public CreateWebChatMessageRequest getBody() {
        return this.body;
    }

    public void setBody(CreateWebChatMessageRequest body) {
        this.body = body;
    }

    public PostConversationsChatCommunicationMessagesRequest withBody(CreateWebChatMessageRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostConversationsChatCommunicationMessagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CreateWebChatMessageRequest> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsChatCommunicationMessagesRequest.");
        }
        if (this.communicationId == null) {
            throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PostConversationsChatCommunicationMessagesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsChatCommunicationMessagesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/conversations/chats/{conversationId}/communications/{communicationId}/messages").withPathParameter("conversationId", this.conversationId).withPathParameter("communicationId", this.communicationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, String communicationId, CreateWebChatMessageRequest body) {
        return new Builder().withRequiredParams(conversationId, communicationId, body);
    }

    public static class Builder {
        private final PostConversationsChatCommunicationMessagesRequest request = new PostConversationsChatCommunicationMessagesRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withCommunicationId(String communicationId) {
            this.request.setCommunicationId(communicationId);
            return this;
        }

        public Builder withBody(CreateWebChatMessageRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, String communicationId, CreateWebChatMessageRequest body) {
            this.request.setConversationId(conversationId);
            this.request.setCommunicationId(communicationId);
            this.request.setBody(body);
            return this;
        }

        public PostConversationsChatCommunicationMessagesRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PostConversationsChatCommunicationMessagesRequest.");
            }
            if (this.request.communicationId == null) {
                throw new IllegalStateException("Missing the required parameter 'communicationId' when building request for PostConversationsChatCommunicationMessagesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostConversationsChatCommunicationMessagesRequest.");
            }
            return this.request;
        }
    }
}

