/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.UserScheduleActivity;
import com.mypurecloud.sdk.v2.model.WeekScheduleReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Single shift in a user's schedule")
public class UserScheduleShift
implements Serializable {
    private WeekScheduleReference weekSchedule = null;
    private String id = null;
    private Date startDate = null;
    private Integer lengthInMinutes = null;
    private List<UserScheduleActivity> activities = new ArrayList<UserScheduleActivity>();
    private Boolean delete = null;
    private Boolean manuallyEdited = null;

    @ApiModelProperty(example="null", value="The schedule to which this shift belongs")
    @JsonProperty(value="weekSchedule")
    public WeekScheduleReference getWeekSchedule() {
        return this.weekSchedule;
    }

    public UserScheduleShift id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="ID of the schedule shift. This is only for the case of updating and deleting an existing shift")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="Start time in UTC for this shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    @ApiModelProperty(example="null", value="Length of this shift in minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public UserScheduleShift activities(List<UserScheduleActivity> activities) {
        this.activities = activities;
        return this;
    }

    @ApiModelProperty(example="null", value="List of activities in this shift")
    @JsonProperty(value="activities")
    public List<UserScheduleActivity> getActivities() {
        return this.activities;
    }

    public void setActivities(List<UserScheduleActivity> activities) {
        this.activities = activities;
    }

    public UserScheduleShift delete(Boolean delete) {
        this.delete = delete;
        return this;
    }

    @ApiModelProperty(example="null", value="If marked true for updating this schedule shift, it will be deleted")
    @JsonProperty(value="delete")
    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public UserScheduleShift manuallyEdited(Boolean manuallyEdited) {
        this.manuallyEdited = manuallyEdited;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the shift was set as manually edited")
    @JsonProperty(value="manuallyEdited")
    public Boolean getManuallyEdited() {
        return this.manuallyEdited;
    }

    public void setManuallyEdited(Boolean manuallyEdited) {
        this.manuallyEdited = manuallyEdited;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserScheduleShift userScheduleShift = (UserScheduleShift)o;
        return Objects.equals(this.weekSchedule, userScheduleShift.weekSchedule) && Objects.equals(this.id, userScheduleShift.id) && Objects.equals(this.startDate, userScheduleShift.startDate) && Objects.equals(this.lengthInMinutes, userScheduleShift.lengthInMinutes) && Objects.equals(this.activities, userScheduleShift.activities) && Objects.equals(this.delete, userScheduleShift.delete) && Objects.equals(this.manuallyEdited, userScheduleShift.manuallyEdited);
    }

    public int hashCode() {
        return Objects.hash(this.weekSchedule, this.id, this.startDate, this.lengthInMinutes, this.activities, this.delete, this.manuallyEdited);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserScheduleShift {\n");
        sb.append("    weekSchedule: ").append(this.toIndentedString(this.weekSchedule)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    activities: ").append(this.toIndentedString(this.activities)).append("\n");
        sb.append("    delete: ").append(this.toIndentedString(this.delete)).append("\n");
        sb.append("    manuallyEdited: ").append(this.toIndentedString(this.manuallyEdited)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

