/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.TextBotErrorInputEvent;
import com.mypurecloud.sdk.v2.model.TextBotTurnReference;
import com.mypurecloud.sdk.v2.model.TextBotUserInputEvent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Settings for a turn request to a bot flow.")
public class TextBotFlowTurnRequest
implements Serializable {
    private TextBotTurnReference previousTurn = null;
    private InputEventTypeEnum inputEventType = null;
    private TextBotUserInputEvent inputEventUserInput = null;
    private TextBotErrorInputEvent inputEventError = null;

    public TextBotFlowTurnRequest previousTurn(TextBotTurnReference previousTurn) {
        this.previousTurn = previousTurn;
        return this;
    }

    @ApiModelProperty(example="null", value="The reference to a previous turn if appropriate, used to avoid race conditions.")
    @JsonProperty(value="previousTurn")
    public TextBotTurnReference getPreviousTurn() {
        return this.previousTurn;
    }

    public void setPreviousTurn(TextBotTurnReference previousTurn) {
        this.previousTurn = previousTurn;
    }

    public TextBotFlowTurnRequest inputEventType(InputEventTypeEnum inputEventType) {
        this.inputEventType = inputEventType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Indicates the type of input event being requested. If appropriate, fill out the matching user input object details on this request.")
    @JsonProperty(value="inputEventType")
    public InputEventTypeEnum getInputEventType() {
        return this.inputEventType;
    }

    public void setInputEventType(InputEventTypeEnum inputEventType) {
        this.inputEventType = inputEventType;
    }

    public TextBotFlowTurnRequest inputEventUserInput(TextBotUserInputEvent inputEventUserInput) {
        this.inputEventUserInput = inputEventUserInput;
        return this;
    }

    @ApiModelProperty(example="null", value="The data for the input event of this turn if it is a user input event. Only one inputEvent may be set.")
    @JsonProperty(value="inputEventUserInput")
    public TextBotUserInputEvent getInputEventUserInput() {
        return this.inputEventUserInput;
    }

    public void setInputEventUserInput(TextBotUserInputEvent inputEventUserInput) {
        this.inputEventUserInput = inputEventUserInput;
    }

    public TextBotFlowTurnRequest inputEventError(TextBotErrorInputEvent inputEventError) {
        this.inputEventError = inputEventError;
        return this;
    }

    @ApiModelProperty(example="null", value="The data for the input event of this turn if it is an error event. Only one inputEvent may be set.")
    @JsonProperty(value="inputEventError")
    public TextBotErrorInputEvent getInputEventError() {
        return this.inputEventError;
    }

    public void setInputEventError(TextBotErrorInputEvent inputEventError) {
        this.inputEventError = inputEventError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotFlowTurnRequest textBotFlowTurnRequest = (TextBotFlowTurnRequest)o;
        return Objects.equals(this.previousTurn, textBotFlowTurnRequest.previousTurn) && Objects.equals((Object)this.inputEventType, (Object)textBotFlowTurnRequest.inputEventType) && Objects.equals(this.inputEventUserInput, textBotFlowTurnRequest.inputEventUserInput) && Objects.equals(this.inputEventError, textBotFlowTurnRequest.inputEventError);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.previousTurn, this.inputEventType, this.inputEventUserInput, this.inputEventError});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotFlowTurnRequest {\n");
        sb.append("    previousTurn: ").append(this.toIndentedString(this.previousTurn)).append("\n");
        sb.append("    inputEventType: ").append(this.toIndentedString((Object)this.inputEventType)).append("\n");
        sb.append("    inputEventUserInput: ").append(this.toIndentedString(this.inputEventUserInput)).append("\n");
        sb.append("    inputEventError: ").append(this.toIndentedString(this.inputEventError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=InputEventTypeEnumDeserializer.class)
    public static enum InputEventTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NOOP("NoOp"),
        USERINPUT("UserInput"),
        ERROR("Error"),
        NOMATCH("NoMatch"),
        NOINPUT("NoInput"),
        USERDISCONNECT("UserDisconnect");

        private String value;

        private InputEventTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static InputEventTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (InputEventTypeEnum value : InputEventTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return InputEventTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class InputEventTypeEnumDeserializer
    extends StdDeserializer<InputEventTypeEnum> {
        public InputEventTypeEnumDeserializer() {
            super(InputEventTypeEnumDeserializer.class);
        }

        public InputEventTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return InputEventTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

