/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.CertificateDetails;
import com.mypurecloud.sdk.v2.model.Division;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A certificate authority represents an organization that has issued a digital certificate for making secure connections with an edge device.")
public class DomainCertificateAuthority
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private String description = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private StateEnum state = null;
    private String modifiedByApp = null;
    private String createdByApp = null;
    private String certificate = null;
    private TypeEnum type = null;
    private List<ServicesEnum> services = new ArrayList<ServicesEnum>();
    private List<CertificateDetails> certificateDetails = new ArrayList<CertificateDetails>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DomainCertificateAuthority name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the entity.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DomainCertificateAuthority division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public DomainCertificateAuthority description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The resource's description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DomainCertificateAuthority version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The current version of the resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public DomainCertificateAuthority dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public DomainCertificateAuthority dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public DomainCertificateAuthority modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that last modified the resource.")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public DomainCertificateAuthority createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="The ID of the user that created the resource.")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="Indicates if the resource is active, inactive, or deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public DomainCertificateAuthority modifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that last modified the resource.")
    @JsonProperty(value="modifiedByApp")
    public String getModifiedByApp() {
        return this.modifiedByApp;
    }

    public void setModifiedByApp(String modifiedByApp) {
        this.modifiedByApp = modifiedByApp;
    }

    public DomainCertificateAuthority createdByApp(String createdByApp) {
        this.createdByApp = createdByApp;
        return this;
    }

    @ApiModelProperty(example="null", value="The application that created the resource.")
    @JsonProperty(value="createdByApp")
    public String getCreatedByApp() {
        return this.createdByApp;
    }

    public void setCreatedByApp(String createdByApp) {
        this.createdByApp = createdByApp;
    }

    public DomainCertificateAuthority certificate(String certificate) {
        this.certificate = certificate;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The authorities signed X509 PEM encoded certificate.")
    @JsonProperty(value="certificate")
    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public DomainCertificateAuthority type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The certificate authorities type.  Managed certificate authorities are generated and maintained by Interactive Intelligence.  These are read-only and not modifiable by clients.  Remote authorities are customer managed.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DomainCertificateAuthority services(List<ServicesEnum> services) {
        this.services = services;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The service(s) that the authority can be used to authenticate.")
    @JsonProperty(value="services")
    public List<ServicesEnum> getServices() {
        return this.services;
    }

    public void setServices(List<ServicesEnum> services) {
        this.services = services;
    }

    public DomainCertificateAuthority certificateDetails(List<CertificateDetails> certificateDetails) {
        this.certificateDetails = certificateDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="The details of the parsed certificate(s).")
    @JsonProperty(value="certificateDetails")
    public List<CertificateDetails> getCertificateDetails() {
        return this.certificateDetails;
    }

    public void setCertificateDetails(List<CertificateDetails> certificateDetails) {
        this.certificateDetails = certificateDetails;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomainCertificateAuthority domainCertificateAuthority = (DomainCertificateAuthority)o;
        return Objects.equals(this.id, domainCertificateAuthority.id) && Objects.equals(this.name, domainCertificateAuthority.name) && Objects.equals(this.division, domainCertificateAuthority.division) && Objects.equals(this.description, domainCertificateAuthority.description) && Objects.equals(this.version, domainCertificateAuthority.version) && Objects.equals(this.dateCreated, domainCertificateAuthority.dateCreated) && Objects.equals(this.dateModified, domainCertificateAuthority.dateModified) && Objects.equals(this.modifiedBy, domainCertificateAuthority.modifiedBy) && Objects.equals(this.createdBy, domainCertificateAuthority.createdBy) && Objects.equals((Object)this.state, (Object)domainCertificateAuthority.state) && Objects.equals(this.modifiedByApp, domainCertificateAuthority.modifiedByApp) && Objects.equals(this.createdByApp, domainCertificateAuthority.createdByApp) && Objects.equals(this.certificate, domainCertificateAuthority.certificate) && Objects.equals((Object)this.type, (Object)domainCertificateAuthority.type) && Objects.equals(this.services, domainCertificateAuthority.services) && Objects.equals(this.certificateDetails, domainCertificateAuthority.certificateDetails) && Objects.equals(this.selfUri, domainCertificateAuthority.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.description, this.version, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.state, this.modifiedByApp, this.createdByApp, this.certificate, this.type, this.services, this.certificateDetails, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DomainCertificateAuthority {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    modifiedByApp: ").append(this.toIndentedString(this.modifiedByApp)).append("\n");
        sb.append("    createdByApp: ").append(this.toIndentedString(this.createdByApp)).append("\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    certificateDetails: ").append(this.toIndentedString(this.certificateDetails)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ServicesEnumDeserializer.class)
    public static enum ServicesEnum {
        SIP("SIP"),
        PROVISION("PROVISION"),
        PROVISION_PHONE("PROVISION_PHONE");

        private String value;

        private ServicesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServicesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ServicesEnum value : ServicesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ServicesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ServicesEnumDeserializer
    extends StdDeserializer<ServicesEnum> {
        public ServicesEnumDeserializer() {
            super(ServicesEnumDeserializer.class);
        }

        public ServicesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ServicesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MANAGED("MANAGED"),
        REMOTE("REMOTE");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

