/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ChatSettings;
import java.util.HashMap;
import java.util.Map;

public class PutChatSettingsRequest {
    private ChatSettings body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public ChatSettings getBody() {
        return this.body;
    }

    public void setBody(ChatSettings body) {
        this.body = body;
    }

    public PutChatSettingsRequest withBody(ChatSettings body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutChatSettingsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ChatSettings> withHttpInfo() {
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutChatSettingsRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/chat/settings").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ChatSettings body) {
        return new Builder().withRequiredParams(body);
    }

    public static class Builder {
        private final PutChatSettingsRequest request = new PutChatSettingsRequest();

        private Builder() {
        }

        public Builder withBody(ChatSettings body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(ChatSettings body) {
            this.request.setBody(body);
            return this;
        }

        public PutChatSettingsRequest build() {
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutChatSettingsRequest.");
            }
            return this.request;
        }
    }
}

