/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ExternalDataSource;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Note
implements Serializable {
    private String id = null;
    private String entityId = null;
    private EntityTypeEnum entityType = null;
    private String noteText = null;
    private Date modifyDate = null;
    private Date createDate = null;
    private User createdBy = null;
    private List<ExternalDataSource> externalDataSources = new ArrayList<ExternalDataSource>();
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Note entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the contact or organization to which this note refers. This only needs to be set for input when using the Bulk APIs.")
    @JsonProperty(value="entityId")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public Note entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="null", value="This is only need to be set when using Bulk API. Using any other value than contact or organization will result in null being used.")
    @JsonProperty(value="entityType")
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public Note noteText(String noteText) {
        this.noteText = noteText;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="noteText")
    public String getNoteText() {
        return this.noteText;
    }

    public void setNoteText(String noteText) {
        this.noteText = noteText;
    }

    public Note modifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="modifyDate")
    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public Note createDate(Date createDate) {
        this.createDate = createDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createDate")
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Note createdBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="When creating or updating a note, only User.id is required. User object is fully populated when expanding a note.")
    @JsonProperty(value="createdBy")
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    @ApiModelProperty(example="null", value="Links to the sources of data (e.g. one source might be a CRM) that contributed data to this record.  Read-only, and only populated when requested via expand param.")
    @JsonProperty(value="externalDataSources")
    public List<ExternalDataSource> getExternalDataSources() {
        return this.externalDataSources;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Note note = (Note)o;
        return Objects.equals(this.id, note.id) && Objects.equals(this.entityId, note.entityId) && Objects.equals((Object)this.entityType, (Object)note.entityType) && Objects.equals(this.noteText, note.noteText) && Objects.equals(this.modifyDate, note.modifyDate) && Objects.equals(this.createDate, note.createDate) && Objects.equals(this.createdBy, note.createdBy) && Objects.equals(this.externalDataSources, note.externalDataSources) && Objects.equals(this.selfUri, note.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.entityId, this.entityType, this.noteText, this.modifyDate, this.createDate, this.createdBy, this.externalDataSources, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Note {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    noteText: ").append(this.toIndentedString(this.noteText)).append("\n");
        sb.append("    modifyDate: ").append(this.toIndentedString(this.modifyDate)).append("\n");
        sb.append("    createDate: ").append(this.toIndentedString(this.createDate)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    externalDataSources: ").append(this.toIndentedString(this.externalDataSources)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=EntityTypeEnumDeserializer.class)
    public static enum EntityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CONTACT("contact"),
        ORGANIZATION("organization");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EntityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EntityTypeEnum value : EntityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EntityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EntityTypeEnumDeserializer
    extends StdDeserializer<EntityTypeEnum> {
        public EntityTypeEnumDeserializer() {
            super(EntityTypeEnumDeserializer.class);
        }

        public EntityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EntityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

