/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.EventEntity;
import com.mypurecloud.sdk.v2.model.MessageInfo;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Describes an event that has happened related to an integration")
public class IntegrationEvent
implements Serializable {
    private String id = null;
    private String selfUri = null;
    private String correlationId = null;
    private Date timestamp = null;
    private LevelEnum level = null;
    private String eventCode = null;
    private MessageInfo message = null;
    private List<EventEntity> entities = new ArrayList<EventEntity>();
    private Map<String, String> contextAttributes = null;
    private MessageInfo detailMessage = null;
    private User user = null;

    @ApiModelProperty(example="null", value="Unique ID for this event")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="Correlation ID for the event")
    @JsonProperty(value="correlationId")
    public String getCorrelationId() {
        return this.correlationId;
    }

    @ApiModelProperty(example="null", value="Time the event occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    @ApiModelProperty(example="null", value="Indicates the severity of the event.")
    @JsonProperty(value="level")
    public LevelEnum getLevel() {
        return this.level;
    }

    @ApiModelProperty(example="null", value="A classification for the event. Suitable for programmatic searching, sorting, or filtering")
    @JsonProperty(value="eventCode")
    public String getEventCode() {
        return this.eventCode;
    }

    @ApiModelProperty(example="null", value="Message indicating what happened")
    @JsonProperty(value="message")
    public MessageInfo getMessage() {
        return this.message;
    }

    @ApiModelProperty(example="null", value="Collection of entities affected by or pertaining to the event (e.g. a list of Integrations or Bridge connectors)")
    @JsonProperty(value="entities")
    public List<EventEntity> getEntities() {
        return this.entities;
    }

    @ApiModelProperty(example="null", value="Map of context attributes specific to this event.")
    @JsonProperty(value="contextAttributes")
    public Map<String, String> getContextAttributes() {
        return this.contextAttributes;
    }

    public IntegrationEvent detailMessage(MessageInfo detailMessage) {
        this.detailMessage = detailMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="Message with additional details about the event. (e.g. an exception cause.)")
    @JsonProperty(value="detailMessage")
    public MessageInfo getDetailMessage() {
        return this.detailMessage;
    }

    public void setDetailMessage(MessageInfo detailMessage) {
        this.detailMessage = detailMessage;
    }

    @ApiModelProperty(example="null", value="User that took an action that resulted in the event.")
    @JsonProperty(value="user")
    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationEvent integrationEvent = (IntegrationEvent)o;
        return Objects.equals(this.id, integrationEvent.id) && Objects.equals(this.selfUri, integrationEvent.selfUri) && Objects.equals(this.correlationId, integrationEvent.correlationId) && Objects.equals(this.timestamp, integrationEvent.timestamp) && Objects.equals((Object)this.level, (Object)integrationEvent.level) && Objects.equals(this.eventCode, integrationEvent.eventCode) && Objects.equals(this.message, integrationEvent.message) && Objects.equals(this.entities, integrationEvent.entities) && Objects.equals(this.contextAttributes, integrationEvent.contextAttributes) && Objects.equals(this.detailMessage, integrationEvent.detailMessage) && Objects.equals(this.user, integrationEvent.user);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.selfUri, this.correlationId, this.timestamp, this.level, this.eventCode, this.message, this.entities, this.contextAttributes, this.detailMessage, this.user});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    level: ").append(this.toIndentedString((Object)this.level)).append("\n");
        sb.append("    eventCode: ").append(this.toIndentedString(this.eventCode)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    contextAttributes: ").append(this.toIndentedString(this.contextAttributes)).append("\n");
        sb.append("    detailMessage: ").append(this.toIndentedString(this.detailMessage)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=LevelEnumDeserializer.class)
    public static enum LevelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR"),
        CRITICAL("CRITICAL");

        private String value;

        private LevelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static LevelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (LevelEnum value : LevelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return LevelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class LevelEnumDeserializer
    extends StdDeserializer<LevelEnum> {
        public LevelEnumDeserializer() {
            super(LevelEnumDeserializer.class);
        }

        public LevelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return LevelEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

