/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class Browser
implements Serializable {
    private String family = null;
    private String version = null;
    private String lang = null;
    private String fingerprint = null;
    private Boolean isMobile = null;
    private Integer viewHeight = null;
    private Integer viewWidth = null;
    private Boolean featuresFlash = null;
    private Boolean featuresJava = null;
    private Boolean featuresPdf = null;
    private Boolean featuresWebrtc = null;

    public Browser family(String family) {
        this.family = family;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Browser family (e.g. Chrome, Safari, Firefox).")
    @JsonProperty(value="family")
    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public Browser version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Browser version (e.g. 68.0.3440.84).")
    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Browser lang(String lang) {
        this.lang = lang;
        return this;
    }

    @ApiModelProperty(example="null", value="Language the browser is set to. Must conform to BCP 47.")
    @JsonProperty(value="lang")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Browser fingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    @ApiModelProperty(example="null", value="Fingerprint generated by looking at the individual browser features.")
    @JsonProperty(value="fingerprint")
    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public Browser isMobile(Boolean isMobile) {
        this.isMobile = isMobile;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag that is true for mobile devices.")
    @JsonProperty(value="isMobile")
    public Boolean getIsMobile() {
        return this.isMobile;
    }

    public void setIsMobile(Boolean isMobile) {
        this.isMobile = isMobile;
    }

    public Browser viewHeight(Integer viewHeight) {
        this.viewHeight = viewHeight;
        return this;
    }

    @ApiModelProperty(example="null", value="Browser's viewport height.")
    @JsonProperty(value="viewHeight")
    public Integer getViewHeight() {
        return this.viewHeight;
    }

    public void setViewHeight(Integer viewHeight) {
        this.viewHeight = viewHeight;
    }

    public Browser viewWidth(Integer viewWidth) {
        this.viewWidth = viewWidth;
        return this;
    }

    @ApiModelProperty(example="null", value="Browser's viewport width.")
    @JsonProperty(value="viewWidth")
    public Integer getViewWidth() {
        return this.viewWidth;
    }

    public void setViewWidth(Integer viewWidth) {
        this.viewWidth = viewWidth;
    }

    public Browser featuresFlash(Boolean featuresFlash) {
        this.featuresFlash = featuresFlash;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether Flash is installed.")
    @JsonProperty(value="featuresFlash")
    public Boolean getFeaturesFlash() {
        return this.featuresFlash;
    }

    public void setFeaturesFlash(Boolean featuresFlash) {
        this.featuresFlash = featuresFlash;
    }

    public Browser featuresJava(Boolean featuresJava) {
        this.featuresJava = featuresJava;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether Java is installed.")
    @JsonProperty(value="featuresJava")
    public Boolean getFeaturesJava() {
        return this.featuresJava;
    }

    public void setFeaturesJava(Boolean featuresJava) {
        this.featuresJava = featuresJava;
    }

    public Browser featuresPdf(Boolean featuresPdf) {
        this.featuresPdf = featuresPdf;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether the browser recognizes PDFs.")
    @JsonProperty(value="featuresPdf")
    public Boolean getFeaturesPdf() {
        return this.featuresPdf;
    }

    public void setFeaturesPdf(Boolean featuresPdf) {
        this.featuresPdf = featuresPdf;
    }

    public Browser featuresWebrtc(Boolean featuresWebrtc) {
        this.featuresWebrtc = featuresWebrtc;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether WebRTC is supported.")
    @JsonProperty(value="featuresWebrtc")
    public Boolean getFeaturesWebrtc() {
        return this.featuresWebrtc;
    }

    public void setFeaturesWebrtc(Boolean featuresWebrtc) {
        this.featuresWebrtc = featuresWebrtc;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Browser browser = (Browser)o;
        return Objects.equals(this.family, browser.family) && Objects.equals(this.version, browser.version) && Objects.equals(this.lang, browser.lang) && Objects.equals(this.fingerprint, browser.fingerprint) && Objects.equals(this.isMobile, browser.isMobile) && Objects.equals(this.viewHeight, browser.viewHeight) && Objects.equals(this.viewWidth, browser.viewWidth) && Objects.equals(this.featuresFlash, browser.featuresFlash) && Objects.equals(this.featuresJava, browser.featuresJava) && Objects.equals(this.featuresPdf, browser.featuresPdf) && Objects.equals(this.featuresWebrtc, browser.featuresWebrtc);
    }

    public int hashCode() {
        return Objects.hash(this.family, this.version, this.lang, this.fingerprint, this.isMobile, this.viewHeight, this.viewWidth, this.featuresFlash, this.featuresJava, this.featuresPdf, this.featuresWebrtc);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Browser {\n");
        sb.append("    family: ").append(this.toIndentedString(this.family)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    lang: ").append(this.toIndentedString(this.lang)).append("\n");
        sb.append("    fingerprint: ").append(this.toIndentedString(this.fingerprint)).append("\n");
        sb.append("    isMobile: ").append(this.toIndentedString(this.isMobile)).append("\n");
        sb.append("    viewHeight: ").append(this.toIndentedString(this.viewHeight)).append("\n");
        sb.append("    viewWidth: ").append(this.toIndentedString(this.viewWidth)).append("\n");
        sb.append("    featuresFlash: ").append(this.toIndentedString(this.featuresFlash)).append("\n");
        sb.append("    featuresJava: ").append(this.toIndentedString(this.featuresJava)).append("\n");
        sb.append("    featuresPdf: ").append(this.toIndentedString(this.featuresPdf)).append("\n");
        sb.append("    featuresWebrtc: ").append(this.toIndentedString(this.featuresWebrtc)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

