/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest {
    private String knowledgeBaseId;
    private String languageCode;
    private String importId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public String getImportId() {
        return this.importId;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest withImportId(String importId) {
        this.setImportId(importId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest.");
        }
        if (this.importId == null) {
            throw new IllegalStateException("Missing the required parameter 'importId' when building request for DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/documents/imports/{importId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("languageCode", this.languageCode).withPathParameter("importId", this.importId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String languageCode, String importId) {
        return new Builder().withRequiredParams(knowledgeBaseId, languageCode, importId);
    }

    public static class Builder {
        private final DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest request = new DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withLanguageCode(languageCodeValues languageCode) {
            this.request.setLanguageCode(languageCode.toString());
            return this;
        }

        public Builder withImportId(String importId) {
            this.request.setImportId(importId);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String languageCode, String importId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setLanguageCode(languageCode);
            this.request.setImportId(importId);
            return this;
        }

        public DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest.");
            }
            if (this.request.importId == null) {
                throw new IllegalStateException("Missing the required parameter 'importId' when building request for DeleteKnowledgeKnowledgebaseLanguageDocumentsImportRequest.");
            }
            return this.request;
        }
    }

    public static enum languageCodeValues {
        EN_US("en-US"),
        EN_UK("en-UK"),
        EN_AU("en-AU"),
        DE_DE("de-DE");

        private String value;

        private languageCodeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static languageCodeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (languageCodeValues value : languageCodeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return languageCodeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

