/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ButtonResponse;
import com.mypurecloud.sdk.v2.model.ExternalContact;
import com.mypurecloud.sdk.v2.model.MessageMediaAttachment;
import com.mypurecloud.sdk.v2.model.MessageStickerAttachment;
import com.mypurecloud.sdk.v2.model.QuickReply;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RecordingMessagingMessage
implements Serializable {
    private String from = null;
    private User fromUser = null;
    private ExternalContact fromExternalContact = null;
    private String to = null;
    private Date timestamp = null;
    private String id = null;
    private String messageText = null;
    private List<MessageMediaAttachment> messageMediaAttachments = new ArrayList<MessageMediaAttachment>();
    private List<MessageStickerAttachment> messageStickerAttachments = new ArrayList<MessageStickerAttachment>();
    private List<QuickReply> quickReplies = new ArrayList<QuickReply>();
    private ButtonResponse buttonResponse = null;

    public RecordingMessagingMessage from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", value="The message sender session id.")
    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public RecordingMessagingMessage fromUser(User fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who sent this message.")
    @JsonProperty(value="fromUser")
    public User getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(User fromUser) {
        this.fromUser = fromUser;
    }

    public RecordingMessagingMessage fromExternalContact(ExternalContact fromExternalContact) {
        this.fromExternalContact = fromExternalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud external contact sender details.")
    @JsonProperty(value="fromExternalContact")
    public ExternalContact getFromExternalContact() {
        return this.fromExternalContact;
    }

    public void setFromExternalContact(ExternalContact fromExternalContact) {
        this.fromExternalContact = fromExternalContact;
    }

    public RecordingMessagingMessage to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", value="The message recipient.")
    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public RecordingMessagingMessage timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the message was sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public RecordingMessagingMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RecordingMessagingMessage messageText(String messageText) {
        this.messageText = messageText;
        return this;
    }

    @ApiModelProperty(example="null", value="The content of this message.")
    @JsonProperty(value="messageText")
    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public RecordingMessagingMessage messageMediaAttachments(List<MessageMediaAttachment> messageMediaAttachments) {
        this.messageMediaAttachments = messageMediaAttachments;
        return this;
    }

    @ApiModelProperty(example="null", value="List of media objects attached  with this message.")
    @JsonProperty(value="messageMediaAttachments")
    public List<MessageMediaAttachment> getMessageMediaAttachments() {
        return this.messageMediaAttachments;
    }

    public void setMessageMediaAttachments(List<MessageMediaAttachment> messageMediaAttachments) {
        this.messageMediaAttachments = messageMediaAttachments;
    }

    public RecordingMessagingMessage messageStickerAttachments(List<MessageStickerAttachment> messageStickerAttachments) {
        this.messageStickerAttachments = messageStickerAttachments;
        return this;
    }

    @ApiModelProperty(example="null", value="List of message stickers attached with this message.")
    @JsonProperty(value="messageStickerAttachments")
    public List<MessageStickerAttachment> getMessageStickerAttachments() {
        return this.messageStickerAttachments;
    }

    public void setMessageStickerAttachments(List<MessageStickerAttachment> messageStickerAttachments) {
        this.messageStickerAttachments = messageStickerAttachments;
    }

    public RecordingMessagingMessage quickReplies(List<QuickReply> quickReplies) {
        this.quickReplies = quickReplies;
        return this;
    }

    @ApiModelProperty(example="null", value="List of quick reply options offered with this message.")
    @JsonProperty(value="quickReplies")
    public List<QuickReply> getQuickReplies() {
        return this.quickReplies;
    }

    public void setQuickReplies(List<QuickReply> quickReplies) {
        this.quickReplies = quickReplies;
    }

    public RecordingMessagingMessage buttonResponse(ButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button Response selected by user for this message.")
    @JsonProperty(value="buttonResponse")
    public ButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(ButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingMessagingMessage recordingMessagingMessage = (RecordingMessagingMessage)o;
        return Objects.equals(this.from, recordingMessagingMessage.from) && Objects.equals(this.fromUser, recordingMessagingMessage.fromUser) && Objects.equals(this.fromExternalContact, recordingMessagingMessage.fromExternalContact) && Objects.equals(this.to, recordingMessagingMessage.to) && Objects.equals(this.timestamp, recordingMessagingMessage.timestamp) && Objects.equals(this.id, recordingMessagingMessage.id) && Objects.equals(this.messageText, recordingMessagingMessage.messageText) && Objects.equals(this.messageMediaAttachments, recordingMessagingMessage.messageMediaAttachments) && Objects.equals(this.messageStickerAttachments, recordingMessagingMessage.messageStickerAttachments) && Objects.equals(this.quickReplies, recordingMessagingMessage.quickReplies) && Objects.equals(this.buttonResponse, recordingMessagingMessage.buttonResponse);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.fromUser, this.fromExternalContact, this.to, this.timestamp, this.id, this.messageText, this.messageMediaAttachments, this.messageStickerAttachments, this.quickReplies, this.buttonResponse);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingMessagingMessage {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    fromUser: ").append(this.toIndentedString(this.fromUser)).append("\n");
        sb.append("    fromExternalContact: ").append(this.toIndentedString(this.fromExternalContact)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    messageText: ").append(this.toIndentedString(this.messageText)).append("\n");
        sb.append("    messageMediaAttachments: ").append(this.toIndentedString(this.messageMediaAttachments)).append("\n");
        sb.append("    messageStickerAttachments: ").append(this.toIndentedString(this.messageStickerAttachments)).append("\n");
        sb.append("    quickReplies: ").append(this.toIndentedString(this.quickReplies)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

