/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.SchedulingProcessingError;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SchedulingStatusResponse
implements Serializable {
    private String id = null;
    private StatusEnum status = null;
    private List<SchedulingProcessingError> errorDetails = new ArrayList<SchedulingProcessingError>();
    private String schedulingResultUri = null;
    private Integer percentComplete = null;

    @ApiModelProperty(example="null", value="The ID generated for the scheduling job.  Use to GET result when job is completed.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The status of the scheduling job.")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public SchedulingStatusResponse errorDetails(List<SchedulingProcessingError> errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(example="null", value="If the request could not be properly processed, error details will be given here.")
    @JsonProperty(value="errorDetails")
    public List<SchedulingProcessingError> getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(List<SchedulingProcessingError> errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(example="null", value="The uri of the scheduling result. It has a value if the status is 'Success'.")
    @JsonProperty(value="schedulingResultUri")
    public String getSchedulingResultUri() {
        return this.schedulingResultUri;
    }

    @ApiModelProperty(example="null", value="The percentage of the job that is complete.")
    @JsonProperty(value="percentComplete")
    public Integer getPercentComplete() {
        return this.percentComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingStatusResponse schedulingStatusResponse = (SchedulingStatusResponse)o;
        return Objects.equals(this.id, schedulingStatusResponse.id) && Objects.equals((Object)this.status, (Object)schedulingStatusResponse.status) && Objects.equals(this.errorDetails, schedulingStatusResponse.errorDetails) && Objects.equals(this.schedulingResultUri, schedulingStatusResponse.schedulingResultUri) && Objects.equals(this.percentComplete, schedulingStatusResponse.percentComplete);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.errorDetails, this.schedulingResultUri, this.percentComplete});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SchedulingStatusResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    schedulingResultUri: ").append(this.toIndentedString(this.schedulingResultUri)).append("\n");
        sb.append("    percentComplete: ").append(this.toIndentedString(this.percentComplete)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        SUCCESS("Success"),
        FAILED("Failed"),
        ONGOING("Ongoing"),
        PARTIALFAILURE("PartialFailure");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

