/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Division;
import com.mypurecloud.sdk.v2.model.ReportingInterval;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class PerformanceProfile
implements Serializable {
    private String id = null;
    private String name = null;
    private Division division = null;
    private String description = null;
    private List<String> metricOrders = new ArrayList<String>();
    private Date dateCreated = null;
    private List<ReportingInterval> reportingIntervals = new ArrayList<ReportingInterval>();
    private Boolean active = null;
    private Integer memberCount = null;
    private Integer maxLeaderboardRankSize = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public PerformanceProfile name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A name for this performance profile")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PerformanceProfile division(Division division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division for this performance profile associate to")
    @JsonProperty(value="division")
    public Division getDivision() {
        return this.division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public PerformanceProfile description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A description about this performance profile")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PerformanceProfile metricOrders(List<String> metricOrders) {
        this.metricOrders = metricOrders;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Order of the associated metrics. The list should contain valid ids for metrics")
    @JsonProperty(value="metricOrders")
    public List<String> getMetricOrders() {
        return this.metricOrders;
    }

    public void setMetricOrders(List<String> metricOrders) {
        this.metricOrders = metricOrders;
    }

    @ApiModelProperty(example="null", value="Creation date for this performance profile. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public PerformanceProfile reportingIntervals(List<ReportingInterval> reportingIntervals) {
        this.reportingIntervals = reportingIntervals;
        return this;
    }

    @ApiModelProperty(example="null", value="The reporting interval periods for this performance profile")
    @JsonProperty(value="reportingIntervals")
    public List<ReportingInterval> getReportingIntervals() {
        return this.reportingIntervals;
    }

    public void setReportingIntervals(List<ReportingInterval> reportingIntervals) {
        this.reportingIntervals = reportingIntervals;
    }

    @ApiModelProperty(example="null", value="The flag for active profiles")
    @JsonProperty(value="active")
    public Boolean getActive() {
        return this.active;
    }

    @ApiModelProperty(example="null", value="The number of members in this performance profile")
    @JsonProperty(value="memberCount")
    public Integer getMemberCount() {
        return this.memberCount;
    }

    public PerformanceProfile maxLeaderboardRankSize(Integer maxLeaderboardRankSize) {
        this.maxLeaderboardRankSize = maxLeaderboardRankSize;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum rank size for the leaderboard. This counts the number of ranks can be retrieved in a leaderboard queries")
    @JsonProperty(value="maxLeaderboardRankSize")
    public Integer getMaxLeaderboardRankSize() {
        return this.maxLeaderboardRankSize;
    }

    public void setMaxLeaderboardRankSize(Integer maxLeaderboardRankSize) {
        this.maxLeaderboardRankSize = maxLeaderboardRankSize;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerformanceProfile performanceProfile = (PerformanceProfile)o;
        return Objects.equals(this.id, performanceProfile.id) && Objects.equals(this.name, performanceProfile.name) && Objects.equals(this.division, performanceProfile.division) && Objects.equals(this.description, performanceProfile.description) && Objects.equals(this.metricOrders, performanceProfile.metricOrders) && Objects.equals(this.dateCreated, performanceProfile.dateCreated) && Objects.equals(this.reportingIntervals, performanceProfile.reportingIntervals) && Objects.equals(this.active, performanceProfile.active) && Objects.equals(this.memberCount, performanceProfile.memberCount) && Objects.equals(this.maxLeaderboardRankSize, performanceProfile.maxLeaderboardRankSize) && Objects.equals(this.selfUri, performanceProfile.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.division, this.description, this.metricOrders, this.dateCreated, this.reportingIntervals, this.active, this.memberCount, this.maxLeaderboardRankSize, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PerformanceProfile {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metricOrders: ").append(this.toIndentedString(this.metricOrders)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    reportingIntervals: ").append(this.toIndentedString(this.reportingIntervals)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    memberCount: ").append(this.toIndentedString(this.memberCount)).append("\n");
        sb.append("    maxLeaderboardRankSize: ").append(this.toIndentedString(this.maxLeaderboardRankSize)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

