/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.FromEmailAddress;
import com.mypurecloud.sdk.v2.model.ReplyToEmailAddress;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EmailConfig
implements Serializable {
    private List<String> emailColumns = new ArrayList<String>();
    private DomainEntityRef contentTemplate = null;
    private FromEmailAddress fromAddress = null;
    private ReplyToEmailAddress replyToAddress = null;

    public EmailConfig emailColumns(List<String> emailColumns) {
        this.emailColumns = emailColumns;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The contact list columns specifying the email address(es) of the contact.")
    @JsonProperty(value="emailColumns")
    public List<String> getEmailColumns() {
        return this.emailColumns;
    }

    public void setEmailColumns(List<String> emailColumns) {
        this.emailColumns = emailColumns;
    }

    public EmailConfig contentTemplate(DomainEntityRef contentTemplate) {
        this.contentTemplate = contentTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="The content template used to formulate the email to send to the contact.")
    @JsonProperty(value="contentTemplate")
    public DomainEntityRef getContentTemplate() {
        return this.contentTemplate;
    }

    public void setContentTemplate(DomainEntityRef contentTemplate) {
        this.contentTemplate = contentTemplate;
    }

    public EmailConfig fromAddress(FromEmailAddress fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The email address that will be used as the sender of the email.")
    @JsonProperty(value="fromAddress")
    public FromEmailAddress getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(FromEmailAddress fromAddress) {
        this.fromAddress = fromAddress;
    }

    public EmailConfig replyToAddress(ReplyToEmailAddress replyToAddress) {
        this.replyToAddress = replyToAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="The email address from which any reply will be sent.")
    @JsonProperty(value="replyToAddress")
    public ReplyToEmailAddress getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReplyToAddress(ReplyToEmailAddress replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailConfig emailConfig = (EmailConfig)o;
        return Objects.equals(this.emailColumns, emailConfig.emailColumns) && Objects.equals(this.contentTemplate, emailConfig.contentTemplate) && Objects.equals(this.fromAddress, emailConfig.fromAddress) && Objects.equals(this.replyToAddress, emailConfig.replyToAddress);
    }

    public int hashCode() {
        return Objects.hash(this.emailColumns, this.contentTemplate, this.fromAddress, this.replyToAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailConfig {\n");
        sb.append("    emailColumns: ").append(this.toIndentedString(this.emailColumns)).append("\n");
        sb.append("    contentTemplate: ").append(this.toIndentedString(this.contentTemplate)).append("\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    replyToAddress: ").append(this.toIndentedString(this.replyToAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

