/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class CreateAgentTimeOffRequest
implements Serializable {
    private String activityCodeId = null;
    private String notes = null;
    private List<String> fullDayManagementUnitDates = new ArrayList<String>();
    private List<Date> partialDayStartDateTimes = new ArrayList<Date>();
    private Integer dailyDurationMinutes = null;

    public CreateAgentTimeOffRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the activity code associated with this time off request. Activity code must be of the TimeOff category")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public CreateAgentTimeOffRequest notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(example="null", value="Notes about the time off request")
    @JsonProperty(value="notes")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public CreateAgentTimeOffRequest fullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.")
    @JsonProperty(value="fullDayManagementUnitDates")
    public List<String> getFullDayManagementUnitDates() {
        return this.fullDayManagementUnitDates;
    }

    public void setFullDayManagementUnitDates(List<String> fullDayManagementUnitDates) {
        this.fullDayManagementUnitDates = fullDayManagementUnitDates;
    }

    public CreateAgentTimeOffRequest partialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
        return this;
    }

    @ApiModelProperty(example="null", value="A set of start date-times in ISO-8601 format for partial day requests.")
    @JsonProperty(value="partialDayStartDateTimes")
    public List<Date> getPartialDayStartDateTimes() {
        return this.partialDayStartDateTimes;
    }

    public void setPartialDayStartDateTimes(List<Date> partialDayStartDateTimes) {
        this.partialDayStartDateTimes = partialDayStartDateTimes;
    }

    public CreateAgentTimeOffRequest dailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The daily duration of this time off request in minutes")
    @JsonProperty(value="dailyDurationMinutes")
    public Integer getDailyDurationMinutes() {
        return this.dailyDurationMinutes;
    }

    public void setDailyDurationMinutes(Integer dailyDurationMinutes) {
        this.dailyDurationMinutes = dailyDurationMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAgentTimeOffRequest createAgentTimeOffRequest = (CreateAgentTimeOffRequest)o;
        return Objects.equals(this.activityCodeId, createAgentTimeOffRequest.activityCodeId) && Objects.equals(this.notes, createAgentTimeOffRequest.notes) && Objects.equals(this.fullDayManagementUnitDates, createAgentTimeOffRequest.fullDayManagementUnitDates) && Objects.equals(this.partialDayStartDateTimes, createAgentTimeOffRequest.partialDayStartDateTimes) && Objects.equals(this.dailyDurationMinutes, createAgentTimeOffRequest.dailyDurationMinutes);
    }

    public int hashCode() {
        return Objects.hash(this.activityCodeId, this.notes, this.fullDayManagementUnitDates, this.partialDayStartDateTimes, this.dailyDurationMinutes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAgentTimeOffRequest {\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    fullDayManagementUnitDates: ").append(this.toIndentedString(this.fullDayManagementUnitDates)).append("\n");
        sb.append("    partialDayStartDateTimes: ").append(this.toIndentedString(this.partialDayStartDateTimes)).append("\n");
        sb.append("    dailyDurationMinutes: ").append(this.toIndentedString(this.dailyDurationMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

