/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ContactColumnTimeZone
implements Serializable {
    private String timeZone = null;
    private ColumnTypeEnum columnType = null;

    public ContactColumnTimeZone timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="Time zone that the column matched to. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @ApiModelProperty(example="null", value="Column Type will be either PHONE or ZIP")
    @JsonProperty(value="columnType")
    public ColumnTypeEnum getColumnType() {
        return this.columnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContactColumnTimeZone contactColumnTimeZone = (ContactColumnTimeZone)o;
        return Objects.equals(this.timeZone, contactColumnTimeZone.timeZone) && Objects.equals((Object)this.columnType, (Object)contactColumnTimeZone.columnType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timeZone, this.columnType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContactColumnTimeZone {\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    columnType: ").append(this.toIndentedString((Object)this.columnType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ColumnTypeEnumDeserializer.class)
    public static enum ColumnTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PHONE("PHONE"),
        ZIP("ZIP");

        private String value;

        private ColumnTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ColumnTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ColumnTypeEnum value : ColumnTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ColumnTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ColumnTypeEnumDeserializer
    extends StdDeserializer<ColumnTypeEnum> {
        public ColumnTypeEnumDeserializer() {
            super(ColumnTypeEnumDeserializer.class);
        }

        public ColumnTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ColumnTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

