/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.InboundDomainPatchRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchRoutingEmailDomainValidateRequest {
    private String domainId;
    private InboundDomainPatchRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public PatchRoutingEmailDomainValidateRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public InboundDomainPatchRequest getBody() {
        return this.body;
    }

    public void setBody(InboundDomainPatchRequest body) {
        this.body = body;
    }

    public PatchRoutingEmailDomainValidateRequest withBody(InboundDomainPatchRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchRoutingEmailDomainValidateRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<InboundDomainPatchRequest> withHttpInfo() {
        if (this.domainId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PatchRoutingEmailDomainValidateRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingEmailDomainValidateRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/routing/email/domains/{domainId}/validate").withPathParameter("domainId", this.domainId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainId, InboundDomainPatchRequest body) {
        return new Builder().withRequiredParams(domainId, body);
    }

    public static class Builder {
        private final PatchRoutingEmailDomainValidateRequest request = new PatchRoutingEmailDomainValidateRequest();

        private Builder() {
        }

        public Builder withDomainId(String domainId) {
            this.request.setDomainId(domainId);
            return this;
        }

        public Builder withBody(InboundDomainPatchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String domainId, InboundDomainPatchRequest body) {
            this.request.setDomainId(domainId);
            this.request.setBody(body);
            return this;
        }

        public PatchRoutingEmailDomainValidateRequest build() {
            if (this.request.domainId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PatchRoutingEmailDomainValidateRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingEmailDomainValidateRequest.");
            }
            return this.request;
        }
    }
}

