/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.TrustMemberCreate;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class TrustCreate
implements Serializable {
    private String pairingId = null;
    private Boolean enabled = null;
    private List<TrustMemberCreate> users = new ArrayList<TrustMemberCreate>();
    private List<TrustMemberCreate> groups = new ArrayList<TrustMemberCreate>();
    private Date dateExpired = null;

    public TrustCreate pairingId(String pairingId) {
        this.pairingId = pairingId;
        return this;
    }

    @ApiModelProperty(example="null", value="The pairing Id created by the trustee. This is required to prove that the trustee agrees to the relationship.  Not required when creating a default pairing with Customer Care.")
    @JsonProperty(value="pairingId")
    public String getPairingId() {
        return this.pairingId;
    }

    public void setPairingId(String pairingId) {
        this.pairingId = pairingId;
    }

    public TrustCreate enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="If disabled no trustee user will have access, even if they were previously added.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TrustCreate users(List<TrustMemberCreate> users) {
        this.users = users;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of users and their roles to which access will be granted. The users are from the trustee and the roles are from the trustor. If no users are specified, at least one group is required.")
    @JsonProperty(value="users")
    public List<TrustMemberCreate> getUsers() {
        return this.users;
    }

    public void setUsers(List<TrustMemberCreate> users) {
        this.users = users;
    }

    public TrustCreate groups(List<TrustMemberCreate> groups) {
        this.groups = groups;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of groups and their roles to which access will be granted. The groups are from the trustee and the roles are from the trustor. If no groups are specified, at least one user is required.")
    @JsonProperty(value="groups")
    public List<TrustMemberCreate> getGroups() {
        return this.groups;
    }

    public void setGroups(List<TrustMemberCreate> groups) {
        this.groups = groups;
    }

    public TrustCreate dateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiration date of the trust. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpired")
    public Date getDateExpired() {
        return this.dateExpired;
    }

    public void setDateExpired(Date dateExpired) {
        this.dateExpired = dateExpired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustCreate trustCreate = (TrustCreate)o;
        return Objects.equals(this.pairingId, trustCreate.pairingId) && Objects.equals(this.enabled, trustCreate.enabled) && Objects.equals(this.users, trustCreate.users) && Objects.equals(this.groups, trustCreate.groups) && Objects.equals(this.dateExpired, trustCreate.dateExpired);
    }

    public int hashCode() {
        return Objects.hash(this.pairingId, this.enabled, this.users, this.groups, this.dateExpired);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustCreate {\n");
        sb.append("    pairingId: ").append(this.toIndentedString(this.pairingId)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    dateExpired: ").append(this.toIndentedString(this.dateExpired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

