/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetGamificationLeaderboardAllBestpointsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationLeaderboardAllRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationLeaderboardBestpointsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationLeaderboardRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationMetricRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationMetricdefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationMetricdefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationMetricsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationProfileRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationProfilesRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsAttendanceRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsBestpointsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsPointsAlltimeRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsPointsAverageRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsPointsTrendsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUserAttendanceRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUserBestpointsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUserPointsAlltimeRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUserPointsTrendsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUserRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUserValuesTrendsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUsersPointsAverageRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUsersValuesAverageRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsUsersValuesTrendsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsValuesAverageRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationScorecardsValuesTrendsRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationStatusRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationTemplateRequest;
import com.mypurecloud.sdk.v2.api.request.GetGamificationTemplatesRequest;
import com.mypurecloud.sdk.v2.api.request.PostGamificationMetricsRequest;
import com.mypurecloud.sdk.v2.api.request.PostGamificationProfileActivateRequest;
import com.mypurecloud.sdk.v2.api.request.PostGamificationProfileDeactivateRequest;
import com.mypurecloud.sdk.v2.api.request.PutGamificationMetricRequest;
import com.mypurecloud.sdk.v2.api.request.PutGamificationProfileRequest;
import com.mypurecloud.sdk.v2.api.request.PutGamificationStatusRequest;
import com.mypurecloud.sdk.v2.model.AllTimePoints;
import com.mypurecloud.sdk.v2.model.AttendanceStatusListing;
import com.mypurecloud.sdk.v2.model.GamificationStatus;
import com.mypurecloud.sdk.v2.model.GetMetricDefinitionsResponse;
import com.mypurecloud.sdk.v2.model.GetMetricsResponse;
import com.mypurecloud.sdk.v2.model.GetProfilesResponse;
import com.mypurecloud.sdk.v2.model.GetTemplatesResponse;
import com.mypurecloud.sdk.v2.model.Leaderboard;
import com.mypurecloud.sdk.v2.model.Metric;
import com.mypurecloud.sdk.v2.model.MetricDefinition;
import com.mypurecloud.sdk.v2.model.ObjectiveTemplate;
import com.mypurecloud.sdk.v2.model.OverallBestPoints;
import com.mypurecloud.sdk.v2.model.PerformanceProfile;
import com.mypurecloud.sdk.v2.model.SingleWorkdayAveragePoints;
import com.mypurecloud.sdk.v2.model.SingleWorkdayAverageValues;
import com.mypurecloud.sdk.v2.model.UserBestPoints;
import com.mypurecloud.sdk.v2.model.WorkdayMetricListing;
import com.mypurecloud.sdk.v2.model.WorkdayPointsTrend;
import com.mypurecloud.sdk.v2.model.WorkdayValuesTrend;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;

public class GamificationApi {
    private final ApiClient pcapiClient;

    public GamificationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GamificationApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Leaderboard getGamificationLeaderboard(LocalDate startWorkday, LocalDate endWorkday, String metricId) throws IOException, ApiException {
        return this.getGamificationLeaderboard(this.createGetGamificationLeaderboardRequest(startWorkday, endWorkday, metricId));
    }

    public ApiResponse<Leaderboard> getGamificationLeaderboardWithHttpInfo(LocalDate startWorkday, LocalDate endWorkday, String metricId) throws IOException {
        return this.getGamificationLeaderboard(this.createGetGamificationLeaderboardRequest(startWorkday, endWorkday, metricId).withHttpInfo());
    }

    private GetGamificationLeaderboardRequest createGetGamificationLeaderboardRequest(LocalDate startWorkday, LocalDate endWorkday, String metricId) {
        return GetGamificationLeaderboardRequest.builder().withStartWorkday(startWorkday).withEndWorkday(endWorkday).withMetricId(metricId).build();
    }

    public Leaderboard getGamificationLeaderboard(GetGamificationLeaderboardRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Leaderboard> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Leaderboard>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Leaderboard> getGamificationLeaderboard(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Leaderboard>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Leaderboard getGamificationLeaderboardAll(String filterType, String filterId, LocalDate startWorkday, LocalDate endWorkday, String metricId) throws IOException, ApiException {
        return this.getGamificationLeaderboardAll(this.createGetGamificationLeaderboardAllRequest(filterType, filterId, startWorkday, endWorkday, metricId));
    }

    public ApiResponse<Leaderboard> getGamificationLeaderboardAllWithHttpInfo(String filterType, String filterId, LocalDate startWorkday, LocalDate endWorkday, String metricId) throws IOException {
        return this.getGamificationLeaderboardAll(this.createGetGamificationLeaderboardAllRequest(filterType, filterId, startWorkday, endWorkday, metricId).withHttpInfo());
    }

    private GetGamificationLeaderboardAllRequest createGetGamificationLeaderboardAllRequest(String filterType, String filterId, LocalDate startWorkday, LocalDate endWorkday, String metricId) {
        return GetGamificationLeaderboardAllRequest.builder().withFilterType(filterType).withFilterId(filterId).withStartWorkday(startWorkday).withEndWorkday(endWorkday).withMetricId(metricId).build();
    }

    public Leaderboard getGamificationLeaderboardAll(GetGamificationLeaderboardAllRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Leaderboard> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Leaderboard>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Leaderboard> getGamificationLeaderboardAll(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Leaderboard>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OverallBestPoints getGamificationLeaderboardAllBestpoints(String filterType, String filterId) throws IOException, ApiException {
        return this.getGamificationLeaderboardAllBestpoints(this.createGetGamificationLeaderboardAllBestpointsRequest(filterType, filterId));
    }

    public ApiResponse<OverallBestPoints> getGamificationLeaderboardAllBestpointsWithHttpInfo(String filterType, String filterId) throws IOException {
        return this.getGamificationLeaderboardAllBestpoints(this.createGetGamificationLeaderboardAllBestpointsRequest(filterType, filterId).withHttpInfo());
    }

    private GetGamificationLeaderboardAllBestpointsRequest createGetGamificationLeaderboardAllBestpointsRequest(String filterType, String filterId) {
        return GetGamificationLeaderboardAllBestpointsRequest.builder().withFilterType(filterType).withFilterId(filterId).build();
    }

    public OverallBestPoints getGamificationLeaderboardAllBestpoints(GetGamificationLeaderboardAllBestpointsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OverallBestPoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OverallBestPoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OverallBestPoints> getGamificationLeaderboardAllBestpoints(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OverallBestPoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public OverallBestPoints getGamificationLeaderboardBestpoints() throws IOException, ApiException {
        return this.getGamificationLeaderboardBestpoints(this.createGetGamificationLeaderboardBestpointsRequest());
    }

    public ApiResponse<OverallBestPoints> getGamificationLeaderboardBestpointsWithHttpInfo() throws IOException {
        return this.getGamificationLeaderboardBestpoints(this.createGetGamificationLeaderboardBestpointsRequest().withHttpInfo());
    }

    private GetGamificationLeaderboardBestpointsRequest createGetGamificationLeaderboardBestpointsRequest() {
        return GetGamificationLeaderboardBestpointsRequest.builder().build();
    }

    public OverallBestPoints getGamificationLeaderboardBestpoints(GetGamificationLeaderboardBestpointsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<OverallBestPoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<OverallBestPoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<OverallBestPoints> getGamificationLeaderboardBestpoints(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<OverallBestPoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Metric getGamificationMetric(String metricId, LocalDate workday, String performanceProfileId) throws IOException, ApiException {
        return this.getGamificationMetric(this.createGetGamificationMetricRequest(metricId, workday, performanceProfileId));
    }

    public ApiResponse<Metric> getGamificationMetricWithHttpInfo(String metricId, LocalDate workday, String performanceProfileId) throws IOException {
        return this.getGamificationMetric(this.createGetGamificationMetricRequest(metricId, workday, performanceProfileId).withHttpInfo());
    }

    private GetGamificationMetricRequest createGetGamificationMetricRequest(String metricId, LocalDate workday, String performanceProfileId) {
        return GetGamificationMetricRequest.builder().withMetricId(metricId).withWorkday(workday).withPerformanceProfileId(performanceProfileId).build();
    }

    public Metric getGamificationMetric(GetGamificationMetricRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Metric> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Metric>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Metric> getGamificationMetric(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Metric>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public MetricDefinition getGamificationMetricdefinition(String metricDefinitionId) throws IOException, ApiException {
        return this.getGamificationMetricdefinition(this.createGetGamificationMetricdefinitionRequest(metricDefinitionId));
    }

    public ApiResponse<MetricDefinition> getGamificationMetricdefinitionWithHttpInfo(String metricDefinitionId) throws IOException {
        return this.getGamificationMetricdefinition(this.createGetGamificationMetricdefinitionRequest(metricDefinitionId).withHttpInfo());
    }

    private GetGamificationMetricdefinitionRequest createGetGamificationMetricdefinitionRequest(String metricDefinitionId) {
        return GetGamificationMetricdefinitionRequest.builder().withMetricDefinitionId(metricDefinitionId).build();
    }

    public MetricDefinition getGamificationMetricdefinition(GetGamificationMetricdefinitionRequest request) throws IOException, ApiException {
        try {
            ApiResponse<MetricDefinition> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<MetricDefinition>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<MetricDefinition> getGamificationMetricdefinition(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<MetricDefinition>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GetMetricDefinitionsResponse getGamificationMetricdefinitions() throws IOException, ApiException {
        return this.getGamificationMetricdefinitions(this.createGetGamificationMetricdefinitionsRequest());
    }

    public ApiResponse<GetMetricDefinitionsResponse> getGamificationMetricdefinitionsWithHttpInfo() throws IOException {
        return this.getGamificationMetricdefinitions(this.createGetGamificationMetricdefinitionsRequest().withHttpInfo());
    }

    private GetGamificationMetricdefinitionsRequest createGetGamificationMetricdefinitionsRequest() {
        return GetGamificationMetricdefinitionsRequest.builder().build();
    }

    public GetMetricDefinitionsResponse getGamificationMetricdefinitions(GetGamificationMetricdefinitionsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GetMetricDefinitionsResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GetMetricDefinitionsResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GetMetricDefinitionsResponse> getGamificationMetricdefinitions(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GetMetricDefinitionsResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GetMetricsResponse getGamificationMetrics(String performanceProfileId, LocalDate workday) throws IOException, ApiException {
        return this.getGamificationMetrics(this.createGetGamificationMetricsRequest(performanceProfileId, workday));
    }

    public ApiResponse<GetMetricsResponse> getGamificationMetricsWithHttpInfo(String performanceProfileId, LocalDate workday) throws IOException {
        return this.getGamificationMetrics(this.createGetGamificationMetricsRequest(performanceProfileId, workday).withHttpInfo());
    }

    private GetGamificationMetricsRequest createGetGamificationMetricsRequest(String performanceProfileId, LocalDate workday) {
        return GetGamificationMetricsRequest.builder().withPerformanceProfileId(performanceProfileId).withWorkday(workday).build();
    }

    public GetMetricsResponse getGamificationMetrics(GetGamificationMetricsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GetMetricsResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GetMetricsResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GetMetricsResponse> getGamificationMetrics(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GetMetricsResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public PerformanceProfile getGamificationProfile(String performanceProfileId) throws IOException, ApiException {
        return this.getGamificationProfile(this.createGetGamificationProfileRequest(performanceProfileId));
    }

    public ApiResponse<PerformanceProfile> getGamificationProfileWithHttpInfo(String performanceProfileId) throws IOException {
        return this.getGamificationProfile(this.createGetGamificationProfileRequest(performanceProfileId).withHttpInfo());
    }

    private GetGamificationProfileRequest createGetGamificationProfileRequest(String performanceProfileId) {
        return GetGamificationProfileRequest.builder().withPerformanceProfileId(performanceProfileId).build();
    }

    public PerformanceProfile getGamificationProfile(GetGamificationProfileRequest request) throws IOException, ApiException {
        try {
            ApiResponse<PerformanceProfile> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<PerformanceProfile>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<PerformanceProfile> getGamificationProfile(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<PerformanceProfile>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GetProfilesResponse getGamificationProfiles() throws IOException, ApiException {
        return this.getGamificationProfiles(this.createGetGamificationProfilesRequest());
    }

    public ApiResponse<GetProfilesResponse> getGamificationProfilesWithHttpInfo() throws IOException {
        return this.getGamificationProfiles(this.createGetGamificationProfilesRequest().withHttpInfo());
    }

    private GetGamificationProfilesRequest createGetGamificationProfilesRequest() {
        return GetGamificationProfilesRequest.builder().build();
    }

    public GetProfilesResponse getGamificationProfiles(GetGamificationProfilesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GetProfilesResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GetProfilesResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GetProfilesResponse> getGamificationProfiles(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GetProfilesResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WorkdayMetricListing getGamificationScorecards(LocalDate workday, List<String> expand) throws IOException, ApiException {
        return this.getGamificationScorecards(this.createGetGamificationScorecardsRequest(workday, expand));
    }

    public ApiResponse<WorkdayMetricListing> getGamificationScorecardsWithHttpInfo(LocalDate workday, List<String> expand) throws IOException {
        return this.getGamificationScorecards(this.createGetGamificationScorecardsRequest(workday, expand).withHttpInfo());
    }

    private GetGamificationScorecardsRequest createGetGamificationScorecardsRequest(LocalDate workday, List<String> expand) {
        return GetGamificationScorecardsRequest.builder().withWorkday(workday).withExpand(expand).build();
    }

    public WorkdayMetricListing getGamificationScorecards(GetGamificationScorecardsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WorkdayMetricListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WorkdayMetricListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WorkdayMetricListing> getGamificationScorecards(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WorkdayMetricListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AttendanceStatusListing getGamificationScorecardsAttendance(LocalDate startWorkday, LocalDate endWorkday) throws IOException, ApiException {
        return this.getGamificationScorecardsAttendance(this.createGetGamificationScorecardsAttendanceRequest(startWorkday, endWorkday));
    }

    public ApiResponse<AttendanceStatusListing> getGamificationScorecardsAttendanceWithHttpInfo(LocalDate startWorkday, LocalDate endWorkday) throws IOException {
        return this.getGamificationScorecardsAttendance(this.createGetGamificationScorecardsAttendanceRequest(startWorkday, endWorkday).withHttpInfo());
    }

    private GetGamificationScorecardsAttendanceRequest createGetGamificationScorecardsAttendanceRequest(LocalDate startWorkday, LocalDate endWorkday) {
        return GetGamificationScorecardsAttendanceRequest.builder().withStartWorkday(startWorkday).withEndWorkday(endWorkday).build();
    }

    public AttendanceStatusListing getGamificationScorecardsAttendance(GetGamificationScorecardsAttendanceRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AttendanceStatusListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AttendanceStatusListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AttendanceStatusListing> getGamificationScorecardsAttendance(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AttendanceStatusListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserBestPoints getGamificationScorecardsBestpoints() throws IOException, ApiException {
        return this.getGamificationScorecardsBestpoints(this.createGetGamificationScorecardsBestpointsRequest());
    }

    public ApiResponse<UserBestPoints> getGamificationScorecardsBestpointsWithHttpInfo() throws IOException {
        return this.getGamificationScorecardsBestpoints(this.createGetGamificationScorecardsBestpointsRequest().withHttpInfo());
    }

    private GetGamificationScorecardsBestpointsRequest createGetGamificationScorecardsBestpointsRequest() {
        return GetGamificationScorecardsBestpointsRequest.builder().build();
    }

    public UserBestPoints getGamificationScorecardsBestpoints(GetGamificationScorecardsBestpointsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserBestPoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserBestPoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserBestPoints> getGamificationScorecardsBestpoints(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserBestPoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AllTimePoints getGamificationScorecardsPointsAlltime(LocalDate endWorkday) throws IOException, ApiException {
        return this.getGamificationScorecardsPointsAlltime(this.createGetGamificationScorecardsPointsAlltimeRequest(endWorkday));
    }

    public ApiResponse<AllTimePoints> getGamificationScorecardsPointsAlltimeWithHttpInfo(LocalDate endWorkday) throws IOException {
        return this.getGamificationScorecardsPointsAlltime(this.createGetGamificationScorecardsPointsAlltimeRequest(endWorkday).withHttpInfo());
    }

    private GetGamificationScorecardsPointsAlltimeRequest createGetGamificationScorecardsPointsAlltimeRequest(LocalDate endWorkday) {
        return GetGamificationScorecardsPointsAlltimeRequest.builder().withEndWorkday(endWorkday).build();
    }

    public AllTimePoints getGamificationScorecardsPointsAlltime(GetGamificationScorecardsPointsAlltimeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AllTimePoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AllTimePoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AllTimePoints> getGamificationScorecardsPointsAlltime(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AllTimePoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SingleWorkdayAveragePoints getGamificationScorecardsPointsAverage(LocalDate workday) throws IOException, ApiException {
        return this.getGamificationScorecardsPointsAverage(this.createGetGamificationScorecardsPointsAverageRequest(workday));
    }

    public ApiResponse<SingleWorkdayAveragePoints> getGamificationScorecardsPointsAverageWithHttpInfo(LocalDate workday) throws IOException {
        return this.getGamificationScorecardsPointsAverage(this.createGetGamificationScorecardsPointsAverageRequest(workday).withHttpInfo());
    }

    private GetGamificationScorecardsPointsAverageRequest createGetGamificationScorecardsPointsAverageRequest(LocalDate workday) {
        return GetGamificationScorecardsPointsAverageRequest.builder().withWorkday(workday).build();
    }

    public SingleWorkdayAveragePoints getGamificationScorecardsPointsAverage(GetGamificationScorecardsPointsAverageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SingleWorkdayAveragePoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SingleWorkdayAveragePoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SingleWorkdayAveragePoints> getGamificationScorecardsPointsAverage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SingleWorkdayAveragePoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WorkdayPointsTrend getGamificationScorecardsPointsTrends(LocalDate startWorkday, LocalDate endWorkday, String dayOfWeek) throws IOException, ApiException {
        return this.getGamificationScorecardsPointsTrends(this.createGetGamificationScorecardsPointsTrendsRequest(startWorkday, endWorkday, dayOfWeek));
    }

    public ApiResponse<WorkdayPointsTrend> getGamificationScorecardsPointsTrendsWithHttpInfo(LocalDate startWorkday, LocalDate endWorkday, String dayOfWeek) throws IOException {
        return this.getGamificationScorecardsPointsTrends(this.createGetGamificationScorecardsPointsTrendsRequest(startWorkday, endWorkday, dayOfWeek).withHttpInfo());
    }

    private GetGamificationScorecardsPointsTrendsRequest createGetGamificationScorecardsPointsTrendsRequest(LocalDate startWorkday, LocalDate endWorkday, String dayOfWeek) {
        return GetGamificationScorecardsPointsTrendsRequest.builder().withStartWorkday(startWorkday).withEndWorkday(endWorkday).withDayOfWeek(dayOfWeek).build();
    }

    public WorkdayPointsTrend getGamificationScorecardsPointsTrends(GetGamificationScorecardsPointsTrendsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WorkdayPointsTrend> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WorkdayPointsTrend>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WorkdayPointsTrend> getGamificationScorecardsPointsTrends(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WorkdayPointsTrend>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WorkdayMetricListing getGamificationScorecardsUser(String userId, LocalDate workday, List<String> expand) throws IOException, ApiException {
        return this.getGamificationScorecardsUser(this.createGetGamificationScorecardsUserRequest(userId, workday, expand));
    }

    public ApiResponse<WorkdayMetricListing> getGamificationScorecardsUserWithHttpInfo(String userId, LocalDate workday, List<String> expand) throws IOException {
        return this.getGamificationScorecardsUser(this.createGetGamificationScorecardsUserRequest(userId, workday, expand).withHttpInfo());
    }

    private GetGamificationScorecardsUserRequest createGetGamificationScorecardsUserRequest(String userId, LocalDate workday, List<String> expand) {
        return GetGamificationScorecardsUserRequest.builder().withUserId(userId).withWorkday(workday).withExpand(expand).build();
    }

    public WorkdayMetricListing getGamificationScorecardsUser(GetGamificationScorecardsUserRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WorkdayMetricListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WorkdayMetricListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WorkdayMetricListing> getGamificationScorecardsUser(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WorkdayMetricListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AttendanceStatusListing getGamificationScorecardsUserAttendance(String userId, LocalDate startWorkday, LocalDate endWorkday) throws IOException, ApiException {
        return this.getGamificationScorecardsUserAttendance(this.createGetGamificationScorecardsUserAttendanceRequest(userId, startWorkday, endWorkday));
    }

    public ApiResponse<AttendanceStatusListing> getGamificationScorecardsUserAttendanceWithHttpInfo(String userId, LocalDate startWorkday, LocalDate endWorkday) throws IOException {
        return this.getGamificationScorecardsUserAttendance(this.createGetGamificationScorecardsUserAttendanceRequest(userId, startWorkday, endWorkday).withHttpInfo());
    }

    private GetGamificationScorecardsUserAttendanceRequest createGetGamificationScorecardsUserAttendanceRequest(String userId, LocalDate startWorkday, LocalDate endWorkday) {
        return GetGamificationScorecardsUserAttendanceRequest.builder().withUserId(userId).withStartWorkday(startWorkday).withEndWorkday(endWorkday).build();
    }

    public AttendanceStatusListing getGamificationScorecardsUserAttendance(GetGamificationScorecardsUserAttendanceRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AttendanceStatusListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AttendanceStatusListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AttendanceStatusListing> getGamificationScorecardsUserAttendance(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AttendanceStatusListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public UserBestPoints getGamificationScorecardsUserBestpoints(String userId) throws IOException, ApiException {
        return this.getGamificationScorecardsUserBestpoints(this.createGetGamificationScorecardsUserBestpointsRequest(userId));
    }

    public ApiResponse<UserBestPoints> getGamificationScorecardsUserBestpointsWithHttpInfo(String userId) throws IOException {
        return this.getGamificationScorecardsUserBestpoints(this.createGetGamificationScorecardsUserBestpointsRequest(userId).withHttpInfo());
    }

    private GetGamificationScorecardsUserBestpointsRequest createGetGamificationScorecardsUserBestpointsRequest(String userId) {
        return GetGamificationScorecardsUserBestpointsRequest.builder().withUserId(userId).build();
    }

    public UserBestPoints getGamificationScorecardsUserBestpoints(GetGamificationScorecardsUserBestpointsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<UserBestPoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<UserBestPoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<UserBestPoints> getGamificationScorecardsUserBestpoints(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<UserBestPoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public AllTimePoints getGamificationScorecardsUserPointsAlltime(String userId, LocalDate endWorkday) throws IOException, ApiException {
        return this.getGamificationScorecardsUserPointsAlltime(this.createGetGamificationScorecardsUserPointsAlltimeRequest(userId, endWorkday));
    }

    public ApiResponse<AllTimePoints> getGamificationScorecardsUserPointsAlltimeWithHttpInfo(String userId, LocalDate endWorkday) throws IOException {
        return this.getGamificationScorecardsUserPointsAlltime(this.createGetGamificationScorecardsUserPointsAlltimeRequest(userId, endWorkday).withHttpInfo());
    }

    private GetGamificationScorecardsUserPointsAlltimeRequest createGetGamificationScorecardsUserPointsAlltimeRequest(String userId, LocalDate endWorkday) {
        return GetGamificationScorecardsUserPointsAlltimeRequest.builder().withUserId(userId).withEndWorkday(endWorkday).build();
    }

    public AllTimePoints getGamificationScorecardsUserPointsAlltime(GetGamificationScorecardsUserPointsAlltimeRequest request) throws IOException, ApiException {
        try {
            ApiResponse<AllTimePoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<AllTimePoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<AllTimePoints> getGamificationScorecardsUserPointsAlltime(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<AllTimePoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WorkdayPointsTrend getGamificationScorecardsUserPointsTrends(String userId, LocalDate startWorkday, LocalDate endWorkday, String dayOfWeek) throws IOException, ApiException {
        return this.getGamificationScorecardsUserPointsTrends(this.createGetGamificationScorecardsUserPointsTrendsRequest(userId, startWorkday, endWorkday, dayOfWeek));
    }

    public ApiResponse<WorkdayPointsTrend> getGamificationScorecardsUserPointsTrendsWithHttpInfo(String userId, LocalDate startWorkday, LocalDate endWorkday, String dayOfWeek) throws IOException {
        return this.getGamificationScorecardsUserPointsTrends(this.createGetGamificationScorecardsUserPointsTrendsRequest(userId, startWorkday, endWorkday, dayOfWeek).withHttpInfo());
    }

    private GetGamificationScorecardsUserPointsTrendsRequest createGetGamificationScorecardsUserPointsTrendsRequest(String userId, LocalDate startWorkday, LocalDate endWorkday, String dayOfWeek) {
        return GetGamificationScorecardsUserPointsTrendsRequest.builder().withUserId(userId).withStartWorkday(startWorkday).withEndWorkday(endWorkday).withDayOfWeek(dayOfWeek).build();
    }

    public WorkdayPointsTrend getGamificationScorecardsUserPointsTrends(GetGamificationScorecardsUserPointsTrendsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WorkdayPointsTrend> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WorkdayPointsTrend>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WorkdayPointsTrend> getGamificationScorecardsUserPointsTrends(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WorkdayPointsTrend>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WorkdayValuesTrend getGamificationScorecardsUserValuesTrends(String userId, LocalDate startWorkday, LocalDate endWorkday, String timeZone) throws IOException, ApiException {
        return this.getGamificationScorecardsUserValuesTrends(this.createGetGamificationScorecardsUserValuesTrendsRequest(userId, startWorkday, endWorkday, timeZone));
    }

    public ApiResponse<WorkdayValuesTrend> getGamificationScorecardsUserValuesTrendsWithHttpInfo(String userId, LocalDate startWorkday, LocalDate endWorkday, String timeZone) throws IOException {
        return this.getGamificationScorecardsUserValuesTrends(this.createGetGamificationScorecardsUserValuesTrendsRequest(userId, startWorkday, endWorkday, timeZone).withHttpInfo());
    }

    private GetGamificationScorecardsUserValuesTrendsRequest createGetGamificationScorecardsUserValuesTrendsRequest(String userId, LocalDate startWorkday, LocalDate endWorkday, String timeZone) {
        return GetGamificationScorecardsUserValuesTrendsRequest.builder().withUserId(userId).withStartWorkday(startWorkday).withEndWorkday(endWorkday).withTimeZone(timeZone).build();
    }

    public WorkdayValuesTrend getGamificationScorecardsUserValuesTrends(GetGamificationScorecardsUserValuesTrendsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WorkdayValuesTrend> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WorkdayValuesTrend>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WorkdayValuesTrend> getGamificationScorecardsUserValuesTrends(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WorkdayValuesTrend>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SingleWorkdayAveragePoints getGamificationScorecardsUsersPointsAverage(String filterType, String filterId, LocalDate workday) throws IOException, ApiException {
        return this.getGamificationScorecardsUsersPointsAverage(this.createGetGamificationScorecardsUsersPointsAverageRequest(filterType, filterId, workday));
    }

    public ApiResponse<SingleWorkdayAveragePoints> getGamificationScorecardsUsersPointsAverageWithHttpInfo(String filterType, String filterId, LocalDate workday) throws IOException {
        return this.getGamificationScorecardsUsersPointsAverage(this.createGetGamificationScorecardsUsersPointsAverageRequest(filterType, filterId, workday).withHttpInfo());
    }

    private GetGamificationScorecardsUsersPointsAverageRequest createGetGamificationScorecardsUsersPointsAverageRequest(String filterType, String filterId, LocalDate workday) {
        return GetGamificationScorecardsUsersPointsAverageRequest.builder().withFilterType(filterType).withFilterId(filterId).withWorkday(workday).build();
    }

    public SingleWorkdayAveragePoints getGamificationScorecardsUsersPointsAverage(GetGamificationScorecardsUsersPointsAverageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SingleWorkdayAveragePoints> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SingleWorkdayAveragePoints>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SingleWorkdayAveragePoints> getGamificationScorecardsUsersPointsAverage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SingleWorkdayAveragePoints>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SingleWorkdayAverageValues getGamificationScorecardsUsersValuesAverage(String filterType, String filterId, LocalDate workday, String timeZone) throws IOException, ApiException {
        return this.getGamificationScorecardsUsersValuesAverage(this.createGetGamificationScorecardsUsersValuesAverageRequest(filterType, filterId, workday, timeZone));
    }

    public ApiResponse<SingleWorkdayAverageValues> getGamificationScorecardsUsersValuesAverageWithHttpInfo(String filterType, String filterId, LocalDate workday, String timeZone) throws IOException {
        return this.getGamificationScorecardsUsersValuesAverage(this.createGetGamificationScorecardsUsersValuesAverageRequest(filterType, filterId, workday, timeZone).withHttpInfo());
    }

    private GetGamificationScorecardsUsersValuesAverageRequest createGetGamificationScorecardsUsersValuesAverageRequest(String filterType, String filterId, LocalDate workday, String timeZone) {
        return GetGamificationScorecardsUsersValuesAverageRequest.builder().withFilterType(filterType).withFilterId(filterId).withWorkday(workday).withTimeZone(timeZone).build();
    }

    public SingleWorkdayAverageValues getGamificationScorecardsUsersValuesAverage(GetGamificationScorecardsUsersValuesAverageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SingleWorkdayAverageValues> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SingleWorkdayAverageValues>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SingleWorkdayAverageValues> getGamificationScorecardsUsersValuesAverage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SingleWorkdayAverageValues>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WorkdayValuesTrend getGamificationScorecardsUsersValuesTrends(String filterType, String filterId, LocalDate startWorkday, LocalDate endWorkday, String timeZone) throws IOException, ApiException {
        return this.getGamificationScorecardsUsersValuesTrends(this.createGetGamificationScorecardsUsersValuesTrendsRequest(filterType, filterId, startWorkday, endWorkday, timeZone));
    }

    public ApiResponse<WorkdayValuesTrend> getGamificationScorecardsUsersValuesTrendsWithHttpInfo(String filterType, String filterId, LocalDate startWorkday, LocalDate endWorkday, String timeZone) throws IOException {
        return this.getGamificationScorecardsUsersValuesTrends(this.createGetGamificationScorecardsUsersValuesTrendsRequest(filterType, filterId, startWorkday, endWorkday, timeZone).withHttpInfo());
    }

    private GetGamificationScorecardsUsersValuesTrendsRequest createGetGamificationScorecardsUsersValuesTrendsRequest(String filterType, String filterId, LocalDate startWorkday, LocalDate endWorkday, String timeZone) {
        return GetGamificationScorecardsUsersValuesTrendsRequest.builder().withFilterType(filterType).withFilterId(filterId).withStartWorkday(startWorkday).withEndWorkday(endWorkday).withTimeZone(timeZone).build();
    }

    public WorkdayValuesTrend getGamificationScorecardsUsersValuesTrends(GetGamificationScorecardsUsersValuesTrendsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WorkdayValuesTrend> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WorkdayValuesTrend>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WorkdayValuesTrend> getGamificationScorecardsUsersValuesTrends(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WorkdayValuesTrend>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public SingleWorkdayAverageValues getGamificationScorecardsValuesAverage(LocalDate workday, String timeZone) throws IOException, ApiException {
        return this.getGamificationScorecardsValuesAverage(this.createGetGamificationScorecardsValuesAverageRequest(workday, timeZone));
    }

    public ApiResponse<SingleWorkdayAverageValues> getGamificationScorecardsValuesAverageWithHttpInfo(LocalDate workday, String timeZone) throws IOException {
        return this.getGamificationScorecardsValuesAverage(this.createGetGamificationScorecardsValuesAverageRequest(workday, timeZone).withHttpInfo());
    }

    private GetGamificationScorecardsValuesAverageRequest createGetGamificationScorecardsValuesAverageRequest(LocalDate workday, String timeZone) {
        return GetGamificationScorecardsValuesAverageRequest.builder().withWorkday(workday).withTimeZone(timeZone).build();
    }

    public SingleWorkdayAverageValues getGamificationScorecardsValuesAverage(GetGamificationScorecardsValuesAverageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<SingleWorkdayAverageValues> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<SingleWorkdayAverageValues>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<SingleWorkdayAverageValues> getGamificationScorecardsValuesAverage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<SingleWorkdayAverageValues>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public WorkdayValuesTrend getGamificationScorecardsValuesTrends(LocalDate startWorkday, LocalDate endWorkday, String filterType, String timeZone) throws IOException, ApiException {
        return this.getGamificationScorecardsValuesTrends(this.createGetGamificationScorecardsValuesTrendsRequest(startWorkday, endWorkday, filterType, timeZone));
    }

    public ApiResponse<WorkdayValuesTrend> getGamificationScorecardsValuesTrendsWithHttpInfo(LocalDate startWorkday, LocalDate endWorkday, String filterType, String timeZone) throws IOException {
        return this.getGamificationScorecardsValuesTrends(this.createGetGamificationScorecardsValuesTrendsRequest(startWorkday, endWorkday, filterType, timeZone).withHttpInfo());
    }

    private GetGamificationScorecardsValuesTrendsRequest createGetGamificationScorecardsValuesTrendsRequest(LocalDate startWorkday, LocalDate endWorkday, String filterType, String timeZone) {
        return GetGamificationScorecardsValuesTrendsRequest.builder().withStartWorkday(startWorkday).withEndWorkday(endWorkday).withFilterType(filterType).withTimeZone(timeZone).build();
    }

    public WorkdayValuesTrend getGamificationScorecardsValuesTrends(GetGamificationScorecardsValuesTrendsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WorkdayValuesTrend> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WorkdayValuesTrend>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WorkdayValuesTrend> getGamificationScorecardsValuesTrends(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WorkdayValuesTrend>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GamificationStatus getGamificationStatus() throws IOException, ApiException {
        return this.getGamificationStatus(this.createGetGamificationStatusRequest());
    }

    public ApiResponse<GamificationStatus> getGamificationStatusWithHttpInfo() throws IOException {
        return this.getGamificationStatus(this.createGetGamificationStatusRequest().withHttpInfo());
    }

    private GetGamificationStatusRequest createGetGamificationStatusRequest() {
        return GetGamificationStatusRequest.builder().build();
    }

    public GamificationStatus getGamificationStatus(GetGamificationStatusRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GamificationStatus> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GamificationStatus>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GamificationStatus> getGamificationStatus(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GamificationStatus>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ObjectiveTemplate getGamificationTemplate(String templateId) throws IOException, ApiException {
        return this.getGamificationTemplate(this.createGetGamificationTemplateRequest(templateId));
    }

    public ApiResponse<ObjectiveTemplate> getGamificationTemplateWithHttpInfo(String templateId) throws IOException {
        return this.getGamificationTemplate(this.createGetGamificationTemplateRequest(templateId).withHttpInfo());
    }

    private GetGamificationTemplateRequest createGetGamificationTemplateRequest(String templateId) {
        return GetGamificationTemplateRequest.builder().withTemplateId(templateId).build();
    }

    public ObjectiveTemplate getGamificationTemplate(GetGamificationTemplateRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ObjectiveTemplate> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ObjectiveTemplate>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ObjectiveTemplate> getGamificationTemplate(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ObjectiveTemplate>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GetTemplatesResponse getGamificationTemplates() throws IOException, ApiException {
        return this.getGamificationTemplates(this.createGetGamificationTemplatesRequest());
    }

    public ApiResponse<GetTemplatesResponse> getGamificationTemplatesWithHttpInfo() throws IOException {
        return this.getGamificationTemplates(this.createGetGamificationTemplatesRequest().withHttpInfo());
    }

    private GetGamificationTemplatesRequest createGetGamificationTemplatesRequest() {
        return GetGamificationTemplatesRequest.builder().build();
    }

    public GetTemplatesResponse getGamificationTemplates(GetGamificationTemplatesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GetTemplatesResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GetTemplatesResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GetTemplatesResponse> getGamificationTemplates(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GetTemplatesResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Metric postGamificationMetrics(Metric body) throws IOException, ApiException {
        return this.postGamificationMetrics(this.createPostGamificationMetricsRequest(body));
    }

    public ApiResponse<Metric> postGamificationMetricsWithHttpInfo(Metric body) throws IOException {
        return this.postGamificationMetrics(this.createPostGamificationMetricsRequest(body).withHttpInfo());
    }

    private PostGamificationMetricsRequest createPostGamificationMetricsRequest(Metric body) {
        return PostGamificationMetricsRequest.builder().withBody(body).build();
    }

    public Metric postGamificationMetrics(PostGamificationMetricsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Metric> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Metric>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Metric> postGamificationMetrics(ApiRequest<Metric> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Metric>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public PerformanceProfile postGamificationProfileActivate(String performanceProfileId) throws IOException, ApiException {
        return this.postGamificationProfileActivate(this.createPostGamificationProfileActivateRequest(performanceProfileId));
    }

    public ApiResponse<PerformanceProfile> postGamificationProfileActivateWithHttpInfo(String performanceProfileId) throws IOException {
        return this.postGamificationProfileActivate(this.createPostGamificationProfileActivateRequest(performanceProfileId).withHttpInfo());
    }

    private PostGamificationProfileActivateRequest createPostGamificationProfileActivateRequest(String performanceProfileId) {
        return PostGamificationProfileActivateRequest.builder().withPerformanceProfileId(performanceProfileId).build();
    }

    public PerformanceProfile postGamificationProfileActivate(PostGamificationProfileActivateRequest request) throws IOException, ApiException {
        try {
            ApiResponse<PerformanceProfile> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<PerformanceProfile>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<PerformanceProfile> postGamificationProfileActivate(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<PerformanceProfile>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public PerformanceProfile postGamificationProfileDeactivate(String performanceProfileId) throws IOException, ApiException {
        return this.postGamificationProfileDeactivate(this.createPostGamificationProfileDeactivateRequest(performanceProfileId));
    }

    public ApiResponse<PerformanceProfile> postGamificationProfileDeactivateWithHttpInfo(String performanceProfileId) throws IOException {
        return this.postGamificationProfileDeactivate(this.createPostGamificationProfileDeactivateRequest(performanceProfileId).withHttpInfo());
    }

    private PostGamificationProfileDeactivateRequest createPostGamificationProfileDeactivateRequest(String performanceProfileId) {
        return PostGamificationProfileDeactivateRequest.builder().withPerformanceProfileId(performanceProfileId).build();
    }

    public PerformanceProfile postGamificationProfileDeactivate(PostGamificationProfileDeactivateRequest request) throws IOException, ApiException {
        try {
            ApiResponse<PerformanceProfile> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<PerformanceProfile>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<PerformanceProfile> postGamificationProfileDeactivate(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<PerformanceProfile>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Metric putGamificationMetric(String metricId, Metric body, String performanceProfileId) throws IOException, ApiException {
        return this.putGamificationMetric(this.createPutGamificationMetricRequest(metricId, body, performanceProfileId));
    }

    public ApiResponse<Metric> putGamificationMetricWithHttpInfo(String metricId, Metric body, String performanceProfileId) throws IOException {
        return this.putGamificationMetric(this.createPutGamificationMetricRequest(metricId, body, performanceProfileId).withHttpInfo());
    }

    private PutGamificationMetricRequest createPutGamificationMetricRequest(String metricId, Metric body, String performanceProfileId) {
        return PutGamificationMetricRequest.builder().withMetricId(metricId).withBody(body).withPerformanceProfileId(performanceProfileId).build();
    }

    public Metric putGamificationMetric(PutGamificationMetricRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Metric> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Metric>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Metric> putGamificationMetric(ApiRequest<Metric> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Metric>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public PerformanceProfile putGamificationProfile(String performanceProfileId, PerformanceProfile body) throws IOException, ApiException {
        return this.putGamificationProfile(this.createPutGamificationProfileRequest(performanceProfileId, body));
    }

    public ApiResponse<PerformanceProfile> putGamificationProfileWithHttpInfo(String performanceProfileId, PerformanceProfile body) throws IOException {
        return this.putGamificationProfile(this.createPutGamificationProfileRequest(performanceProfileId, body).withHttpInfo());
    }

    private PutGamificationProfileRequest createPutGamificationProfileRequest(String performanceProfileId, PerformanceProfile body) {
        return PutGamificationProfileRequest.builder().withPerformanceProfileId(performanceProfileId).withBody(body).build();
    }

    public PerformanceProfile putGamificationProfile(PutGamificationProfileRequest request) throws IOException, ApiException {
        try {
            ApiResponse<PerformanceProfile> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<PerformanceProfile>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<PerformanceProfile> putGamificationProfile(ApiRequest<PerformanceProfile> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<PerformanceProfile>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public GamificationStatus putGamificationStatus(GamificationStatus status) throws IOException, ApiException {
        return this.putGamificationStatus(this.createPutGamificationStatusRequest(status));
    }

    public ApiResponse<GamificationStatus> putGamificationStatusWithHttpInfo(GamificationStatus status) throws IOException {
        return this.putGamificationStatus(this.createPutGamificationStatusRequest(status).withHttpInfo());
    }

    private PutGamificationStatusRequest createPutGamificationStatusRequest(GamificationStatus status) {
        return PutGamificationStatusRequest.builder().withStatus(status).build();
    }

    public GamificationStatus putGamificationStatus(PutGamificationStatusRequest request) throws IOException, ApiException {
        try {
            ApiResponse<GamificationStatus> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<GamificationStatus>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<GamificationStatus> putGamificationStatus(ApiRequest<GamificationStatus> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<GamificationStatus>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

