/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.MessagingTemplateRequest;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AdditionalMessage
implements Serializable {
    private String textBody = null;
    private List<String> mediaIds = new ArrayList<String>();
    private List<String> stickerIds = new ArrayList<String>();
    private MessagingTemplateRequest messagingTemplate = null;

    public AdditionalMessage textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The body of the text message.")
    @JsonProperty(value="textBody")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public AdditionalMessage mediaIds(List<String> mediaIds) {
        this.mediaIds = mediaIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The media ids associated with the text message. See https://developer.genesys.cloud/api/rest/v2/conversations/messaging-media-upload for example usage.")
    @JsonProperty(value="mediaIds")
    public List<String> getMediaIds() {
        return this.mediaIds;
    }

    public void setMediaIds(List<String> mediaIds) {
        this.mediaIds = mediaIds;
    }

    public AdditionalMessage stickerIds(List<String> stickerIds) {
        this.stickerIds = stickerIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The sticker ids associated with the text message.")
    @JsonProperty(value="stickerIds")
    public List<String> getStickerIds() {
        return this.stickerIds;
    }

    public void setStickerIds(List<String> stickerIds) {
        this.stickerIds = stickerIds;
    }

    public AdditionalMessage messagingTemplate(MessagingTemplateRequest messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="The messaging template use to send a predefined canned response with the message")
    @JsonProperty(value="messagingTemplate")
    public MessagingTemplateRequest getMessagingTemplate() {
        return this.messagingTemplate;
    }

    public void setMessagingTemplate(MessagingTemplateRequest messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalMessage additionalMessage = (AdditionalMessage)o;
        return Objects.equals(this.textBody, additionalMessage.textBody) && Objects.equals(this.mediaIds, additionalMessage.mediaIds) && Objects.equals(this.stickerIds, additionalMessage.stickerIds) && Objects.equals(this.messagingTemplate, additionalMessage.messagingTemplate);
    }

    public int hashCode() {
        return Objects.hash(this.textBody, this.mediaIds, this.stickerIds, this.messagingTemplate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalMessage {\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    mediaIds: ").append(this.toIndentedString(this.mediaIds)).append("\n");
        sb.append("    stickerIds: ").append(this.toIndentedString(this.stickerIds)).append("\n");
        sb.append("    messagingTemplate: ").append(this.toIndentedString(this.messagingTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

