/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CoachingSlotsRequest
implements Serializable {
    private String interval = null;
    private Integer lengthInMinutes = null;
    private List<String> attendeeIds = new ArrayList<String>();
    private List<String> facilitatorIds = new ArrayList<String>();

    public CoachingSlotsRequest interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Range of time to get slots for scheduling coaching appointments. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public CoachingSlotsRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The duration of coaching appointment to schedule in 15 minutes granularity up to maximum of 60 minutes")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public CoachingSlotsRequest attendeeIds(List<String> attendeeIds) {
        this.attendeeIds = attendeeIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="List of attendees to determine coaching appointment slots")
    @JsonProperty(value="attendeeIds")
    public List<String> getAttendeeIds() {
        return this.attendeeIds;
    }

    public void setAttendeeIds(List<String> attendeeIds) {
        this.attendeeIds = attendeeIds;
    }

    public CoachingSlotsRequest facilitatorIds(List<String> facilitatorIds) {
        this.facilitatorIds = facilitatorIds;
        return this;
    }

    @ApiModelProperty(example="null", value="List of facilitators to determine coaching appointment slots")
    @JsonProperty(value="facilitatorIds")
    public List<String> getFacilitatorIds() {
        return this.facilitatorIds;
    }

    public void setFacilitatorIds(List<String> facilitatorIds) {
        this.facilitatorIds = facilitatorIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoachingSlotsRequest coachingSlotsRequest = (CoachingSlotsRequest)o;
        return Objects.equals(this.interval, coachingSlotsRequest.interval) && Objects.equals(this.lengthInMinutes, coachingSlotsRequest.lengthInMinutes) && Objects.equals(this.attendeeIds, coachingSlotsRequest.attendeeIds) && Objects.equals(this.facilitatorIds, coachingSlotsRequest.facilitatorIds);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.lengthInMinutes, this.attendeeIds, this.facilitatorIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoachingSlotsRequest {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    attendeeIds: ").append(this.toIndentedString(this.attendeeIds)).append("\n");
        sb.append("    facilitatorIds: ").append(this.toIndentedString(this.facilitatorIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

