/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteKnowledgeKnowledgebaseLanguageCategoryRequest {
    private String categoryId;
    private String knowledgeBaseId;
    private String languageCode;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public DeleteKnowledgeKnowledgebaseLanguageCategoryRequest withCategoryId(String categoryId) {
        this.setCategoryId(categoryId);
        return this;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public DeleteKnowledgeKnowledgebaseLanguageCategoryRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public DeleteKnowledgeKnowledgebaseLanguageCategoryRequest withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteKnowledgeKnowledgebaseLanguageCategoryRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.categoryId == null) {
            throw new IllegalStateException("Missing the required parameter 'categoryId' when building request for DeleteKnowledgeKnowledgebaseLanguageCategoryRequest.");
        }
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for DeleteKnowledgeKnowledgebaseLanguageCategoryRequest.");
        }
        if (this.languageCode == null) {
            throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for DeleteKnowledgeKnowledgebaseLanguageCategoryRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/languages/{languageCode}/categories/{categoryId}").withPathParameter("categoryId", this.categoryId).withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("languageCode", this.languageCode).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String categoryId, String knowledgeBaseId, String languageCode) {
        return new Builder().withRequiredParams(categoryId, knowledgeBaseId, languageCode);
    }

    public static class Builder {
        private final DeleteKnowledgeKnowledgebaseLanguageCategoryRequest request = new DeleteKnowledgeKnowledgebaseLanguageCategoryRequest();

        private Builder() {
        }

        public Builder withCategoryId(String categoryId) {
            this.request.setCategoryId(categoryId);
            return this;
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withLanguageCode(String languageCode) {
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public Builder withLanguageCode(languageCodeValues languageCode) {
            this.request.setLanguageCode(languageCode.toString());
            return this;
        }

        public Builder withRequiredParams(String categoryId, String knowledgeBaseId, String languageCode) {
            this.request.setCategoryId(categoryId);
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setLanguageCode(languageCode);
            return this;
        }

        public DeleteKnowledgeKnowledgebaseLanguageCategoryRequest build() {
            if (this.request.categoryId == null) {
                throw new IllegalStateException("Missing the required parameter 'categoryId' when building request for DeleteKnowledgeKnowledgebaseLanguageCategoryRequest.");
            }
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for DeleteKnowledgeKnowledgebaseLanguageCategoryRequest.");
            }
            if (this.request.languageCode == null) {
                throw new IllegalStateException("Missing the required parameter 'languageCode' when building request for DeleteKnowledgeKnowledgebaseLanguageCategoryRequest.");
            }
            return this.request;
        }
    }

    public static enum languageCodeValues {
        EN_US("en-US"),
        DE_DE("de-DE");

        private String value;

        private languageCodeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static languageCodeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (languageCodeValues value : languageCodeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return languageCodeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

