/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.LineStatus;
import com.mypurecloud.sdk.v2.model.ProvisionInfo;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PhoneStatus
implements Serializable {
    private String id = null;
    private String name = null;
    private OperationalStatusEnum operationalStatus = null;
    private EdgesStatusEnum edgesStatus = null;
    private String eventCreationTime = null;
    private ProvisionInfo provision = null;
    private List<LineStatus> lineStatuses = new ArrayList<LineStatus>();
    private PhoneAssignmentToEdgeTypeEnum phoneAssignmentToEdgeType = null;
    private DomainEntityRef edge = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public PhoneStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PhoneStatus operationalStatus(OperationalStatusEnum operationalStatus) {
        this.operationalStatus = operationalStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The Operational Status of this phone")
    @JsonProperty(value="operationalStatus")
    public OperationalStatusEnum getOperationalStatus() {
        return this.operationalStatus;
    }

    public void setOperationalStatus(OperationalStatusEnum operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public PhoneStatus edgesStatus(EdgesStatusEnum edgesStatus) {
        this.edgesStatus = edgesStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the primary or secondary Edges assigned to the phone lines.")
    @JsonProperty(value="edgesStatus")
    public EdgesStatusEnum getEdgesStatus() {
        return this.edgesStatus;
    }

    public void setEdgesStatus(EdgesStatusEnum edgesStatus) {
        this.edgesStatus = edgesStatus;
    }

    public PhoneStatus eventCreationTime(String eventCreationTime) {
        this.eventCreationTime = eventCreationTime;
        return this;
    }

    @ApiModelProperty(example="null", value="Event Creation Time represents an ISO-8601 string. For example: UTC, UTC+01:00, or Europe/London")
    @JsonProperty(value="eventCreationTime")
    public String getEventCreationTime() {
        return this.eventCreationTime;
    }

    public void setEventCreationTime(String eventCreationTime) {
        this.eventCreationTime = eventCreationTime;
    }

    public PhoneStatus provision(ProvisionInfo provision) {
        this.provision = provision;
        return this;
    }

    @ApiModelProperty(example="null", value="Provision information for this phone")
    @JsonProperty(value="provision")
    public ProvisionInfo getProvision() {
        return this.provision;
    }

    public void setProvision(ProvisionInfo provision) {
        this.provision = provision;
    }

    public PhoneStatus lineStatuses(List<LineStatus> lineStatuses) {
        this.lineStatuses = lineStatuses;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of LineStatus information for each of the lines of this phone")
    @JsonProperty(value="lineStatuses")
    public List<LineStatus> getLineStatuses() {
        return this.lineStatuses;
    }

    public void setLineStatuses(List<LineStatus> lineStatuses) {
        this.lineStatuses = lineStatuses;
    }

    public PhoneStatus phoneAssignmentToEdgeType(PhoneAssignmentToEdgeTypeEnum phoneAssignmentToEdgeType) {
        this.phoneAssignmentToEdgeType = phoneAssignmentToEdgeType;
        return this;
    }

    @ApiModelProperty(example="null", value="The phone status's edge assignment type.")
    @JsonProperty(value="phoneAssignmentToEdgeType")
    public PhoneAssignmentToEdgeTypeEnum getPhoneAssignmentToEdgeType() {
        return this.phoneAssignmentToEdgeType;
    }

    public void setPhoneAssignmentToEdgeType(PhoneAssignmentToEdgeTypeEnum phoneAssignmentToEdgeType) {
        this.phoneAssignmentToEdgeType = phoneAssignmentToEdgeType;
    }

    public PhoneStatus edge(DomainEntityRef edge) {
        this.edge = edge;
        return this;
    }

    @ApiModelProperty(example="null", value="The URI of the edge that provided this status information.")
    @JsonProperty(value="edge")
    public DomainEntityRef getEdge() {
        return this.edge;
    }

    public void setEdge(DomainEntityRef edge) {
        this.edge = edge;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhoneStatus phoneStatus = (PhoneStatus)o;
        return Objects.equals(this.id, phoneStatus.id) && Objects.equals(this.name, phoneStatus.name) && Objects.equals((Object)this.operationalStatus, (Object)phoneStatus.operationalStatus) && Objects.equals((Object)this.edgesStatus, (Object)phoneStatus.edgesStatus) && Objects.equals(this.eventCreationTime, phoneStatus.eventCreationTime) && Objects.equals(this.provision, phoneStatus.provision) && Objects.equals(this.lineStatuses, phoneStatus.lineStatuses) && Objects.equals((Object)this.phoneAssignmentToEdgeType, (Object)phoneStatus.phoneAssignmentToEdgeType) && Objects.equals(this.edge, phoneStatus.edge) && Objects.equals(this.selfUri, phoneStatus.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.operationalStatus, this.edgesStatus, this.eventCreationTime, this.provision, this.lineStatuses, this.phoneAssignmentToEdgeType, this.edge, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PhoneStatus {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    operationalStatus: ").append(this.toIndentedString((Object)this.operationalStatus)).append("\n");
        sb.append("    edgesStatus: ").append(this.toIndentedString((Object)this.edgesStatus)).append("\n");
        sb.append("    eventCreationTime: ").append(this.toIndentedString(this.eventCreationTime)).append("\n");
        sb.append("    provision: ").append(this.toIndentedString(this.provision)).append("\n");
        sb.append("    lineStatuses: ").append(this.toIndentedString(this.lineStatuses)).append("\n");
        sb.append("    phoneAssignmentToEdgeType: ").append(this.toIndentedString((Object)this.phoneAssignmentToEdgeType)).append("\n");
        sb.append("    edge: ").append(this.toIndentedString(this.edge)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PhoneAssignmentToEdgeTypeEnumDeserializer.class)
    public static enum PhoneAssignmentToEdgeTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PRIMARY("PRIMARY"),
        SECONDARY("SECONDARY");

        private String value;

        private PhoneAssignmentToEdgeTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PhoneAssignmentToEdgeTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PhoneAssignmentToEdgeTypeEnum value : PhoneAssignmentToEdgeTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PhoneAssignmentToEdgeTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PhoneAssignmentToEdgeTypeEnumDeserializer
    extends StdDeserializer<PhoneAssignmentToEdgeTypeEnum> {
        public PhoneAssignmentToEdgeTypeEnumDeserializer() {
            super(PhoneAssignmentToEdgeTypeEnumDeserializer.class);
        }

        public PhoneAssignmentToEdgeTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PhoneAssignmentToEdgeTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=EdgesStatusEnumDeserializer.class)
    public static enum EdgesStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        IN_SERVICE("IN_SERVICE"),
        MIXED_SERVICE("MIXED_SERVICE"),
        OUT_OF_SERVICE("OUT_OF_SERVICE"),
        NO_EDGES("NO_EDGES");

        private String value;

        private EdgesStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EdgesStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EdgesStatusEnum value : EdgesStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EdgesStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EdgesStatusEnumDeserializer
    extends StdDeserializer<EdgesStatusEnum> {
        public EdgesStatusEnumDeserializer() {
            super(EdgesStatusEnumDeserializer.class);
        }

        public EdgesStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EdgesStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=OperationalStatusEnumDeserializer.class)
    public static enum OperationalStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPERATIONAL("OPERATIONAL"),
        DEGRADED("DEGRADED"),
        OFFLINE("OFFLINE");

        private String value;

        private OperationalStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperationalStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperationalStatusEnum value : OperationalStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperationalStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperationalStatusEnumDeserializer
    extends StdDeserializer<OperationalStatusEnum> {
        public OperationalStatusEnumDeserializer() {
            super(OperationalStatusEnumDeserializer.class);
        }

        public OperationalStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperationalStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

