/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ExternalSegment
implements Serializable {
    private String id = null;
    private String name = null;
    private SourceEnum source = null;

    public ExternalSegment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Identifier for the external segment in the system where it originates from.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExternalSegment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name for the external segment in the system where it originates from.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ExternalSegment source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The external system where the segment originates from.")
    @JsonProperty(value="source")
    public SourceEnum getSource() {
        return this.source;
    }

    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSegment externalSegment = (ExternalSegment)o;
        return Objects.equals(this.id, externalSegment.id) && Objects.equals(this.name, externalSegment.name) && Objects.equals((Object)this.source, (Object)externalSegment.source);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.source});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalSegment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SourceEnumDeserializer.class)
    public static enum SourceEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ADOBEEXPERIENCEPLATFORM("AdobeExperiencePlatform"),
        CUSTOM("Custom");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceEnum value : SourceEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceEnumDeserializer
    extends StdDeserializer<SourceEnum> {
        public SourceEnumDeserializer() {
            super(SourceEnumDeserializer.class);
        }

        public SourceEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

