/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PostAuthorizationDivisionObjectRequest {
    private String divisionId;
    private String objectType;
    private List<String> body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDivisionId() {
        return this.divisionId;
    }

    public void setDivisionId(String divisionId) {
        this.divisionId = divisionId;
    }

    public PostAuthorizationDivisionObjectRequest withDivisionId(String divisionId) {
        this.setDivisionId(divisionId);
        return this;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public PostAuthorizationDivisionObjectRequest withObjectType(String objectType) {
        this.setObjectType(objectType);
        return this;
    }

    public List<String> getBody() {
        return this.body;
    }

    public void setBody(List<String> body) {
        this.body = body;
    }

    public PostAuthorizationDivisionObjectRequest withBody(List<String> body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostAuthorizationDivisionObjectRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<String>> withHttpInfo() {
        if (this.divisionId == null) {
            throw new IllegalStateException("Missing the required parameter 'divisionId' when building request for PostAuthorizationDivisionObjectRequest.");
        }
        if (this.objectType == null) {
            throw new IllegalStateException("Missing the required parameter 'objectType' when building request for PostAuthorizationDivisionObjectRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAuthorizationDivisionObjectRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/authorization/divisions/{divisionId}/objects/{objectType}").withPathParameter("divisionId", this.divisionId).withPathParameter("objectType", this.objectType).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String divisionId, String objectType, List<String> body) {
        return new Builder().withRequiredParams(divisionId, objectType, body);
    }

    public static class Builder {
        private final PostAuthorizationDivisionObjectRequest request = new PostAuthorizationDivisionObjectRequest();

        private Builder() {
        }

        public Builder withDivisionId(String divisionId) {
            this.request.setDivisionId(divisionId);
            return this;
        }

        public Builder withObjectType(String objectType) {
            this.request.setObjectType(objectType);
            return this;
        }

        public Builder withObjectType(objectTypeValues objectType) {
            this.request.setObjectType(objectType.toString());
            return this;
        }

        public Builder withBody(List<String> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String divisionId, String objectType, List<String> body) {
            this.request.setDivisionId(divisionId);
            this.request.setObjectType(objectType);
            this.request.setBody(body);
            return this;
        }

        public PostAuthorizationDivisionObjectRequest build() {
            if (this.request.divisionId == null) {
                throw new IllegalStateException("Missing the required parameter 'divisionId' when building request for PostAuthorizationDivisionObjectRequest.");
            }
            if (this.request.objectType == null) {
                throw new IllegalStateException("Missing the required parameter 'objectType' when building request for PostAuthorizationDivisionObjectRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAuthorizationDivisionObjectRequest.");
            }
            return this.request;
        }
    }

    public static enum objectTypeValues {
        QUEUE("QUEUE"),
        CAMPAIGN("CAMPAIGN"),
        CONTACTLIST("CONTACTLIST"),
        DNCLIST("DNCLIST"),
        MESSAGINGCAMPAIGN("MESSAGINGCAMPAIGN"),
        MANAGEMENTUNIT("MANAGEMENTUNIT"),
        BUSINESSUNIT("BUSINESSUNIT"),
        FLOW("FLOW"),
        USER("USER"),
        DATATABLES("DATATABLES");

        private String value;

        private objectTypeValues(String value) {
            this.value = value;
        }

        @JsonCreator
        public static objectTypeValues fromString(String key) {
            if (key == null) {
                return null;
            }
            for (objectTypeValues value : objectTypeValues.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return objectTypeValues.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

