/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContentActions;
import com.mypurecloud.sdk.v2.model.ListItemComponent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="List content object")
public class ContentList
implements Serializable {
    private String id = null;
    private ListTypeEnum listType = null;
    private String title = null;
    private String description = null;
    private String submitLabel = null;
    private ContentActions actions = null;
    private List<ListItemComponent> components = new ArrayList<ListItemComponent>();

    public ContentList id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="An ID assigned to this rich message content. Each instance inside the content array has a unique ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ContentList listType(ListTypeEnum listType) {
        this.listType = listType;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of list this instance represents")
    @JsonProperty(value="listType")
    public ListTypeEnum getListType() {
        return this.listType;
    }

    public void setListType(ListTypeEnum listType) {
        this.listType = listType;
    }

    public ContentList title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the title row")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ContentList description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the description row. This is immediately below the title")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ContentList submitLabel(String submitLabel) {
        this.submitLabel = submitLabel;
        return this;
    }

    @ApiModelProperty(example="null", value="Label for Submit button")
    @JsonProperty(value="submitLabel")
    public String getSubmitLabel() {
        return this.submitLabel;
    }

    public void setSubmitLabel(String submitLabel) {
        this.submitLabel = submitLabel;
    }

    public ContentList actions(ContentActions actions) {
        this.actions = actions;
        return this;
    }

    @ApiModelProperty(example="null", value="User actions available on the content. All actions are optional and all actions are executed simultaneously.")
    @JsonProperty(value="actions")
    public ContentActions getActions() {
        return this.actions;
    }

    public void setActions(ContentActions actions) {
        this.actions = actions;
    }

    public ContentList components(List<ListItemComponent> components) {
        this.components = components;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of component objects")
    @JsonProperty(value="components")
    public List<ListItemComponent> getComponents() {
        return this.components;
    }

    public void setComponents(List<ListItemComponent> components) {
        this.components = components;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentList contentList = (ContentList)o;
        return Objects.equals(this.id, contentList.id) && Objects.equals((Object)this.listType, (Object)contentList.listType) && Objects.equals(this.title, contentList.title) && Objects.equals(this.description, contentList.description) && Objects.equals(this.submitLabel, contentList.submitLabel) && Objects.equals(this.actions, contentList.actions) && Objects.equals(this.components, contentList.components);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.listType, this.title, this.description, this.submitLabel, this.actions, this.components});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContentList {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    listType: ").append(this.toIndentedString((Object)this.listType)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    submitLabel: ").append(this.toIndentedString(this.submitLabel)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ListTypeEnumDeserializer.class)
    public static enum ListTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SELECTION("Selection"),
        VERTICAL("Vertical");

        private String value;

        private ListTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ListTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ListTypeEnum value : ListTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ListTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ListTypeEnumDeserializer
    extends StdDeserializer<ListTypeEnum> {
        public ListTypeEnumDeserializer() {
            super(ListTypeEnumDeserializer.class);
        }

        public ListTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ListTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

