/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.OrgUser;
import com.mypurecloud.sdk.v2.model.Organization;
import com.mypurecloud.sdk.v2.model.TrusteeAuthorization;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Trustor
implements Serializable {
    private String id = null;
    private Boolean enabled = null;
    private Date dateCreated = null;
    private OrgUser createdBy = null;
    private Organization organization = null;
    private TrusteeAuthorization authorization = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="Organization Id for this trust.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public Trustor enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="If disabled no trustee user will have access, even if they were previously added.")
    @JsonProperty(value="enabled")
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @ApiModelProperty(example="null", value="Date Trust was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Trustor createdBy(OrgUser createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that created trust.")
    @JsonProperty(value="createdBy")
    public OrgUser getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(OrgUser createdBy) {
        this.createdBy = createdBy;
    }

    public Trustor organization(Organization organization) {
        this.organization = organization;
        return this;
    }

    @ApiModelProperty(example="null", value="Organization associated with this trust.")
    @JsonProperty(value="organization")
    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Trustor authorization(TrusteeAuthorization authorization) {
        this.authorization = authorization;
        return this;
    }

    @ApiModelProperty(example="null", value="Authorization for the trustee user has in this trustor organization")
    @JsonProperty(value="authorization")
    public TrusteeAuthorization getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(TrusteeAuthorization authorization) {
        this.authorization = authorization;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trustor trustor = (Trustor)o;
        return Objects.equals(this.id, trustor.id) && Objects.equals(this.enabled, trustor.enabled) && Objects.equals(this.dateCreated, trustor.dateCreated) && Objects.equals(this.createdBy, trustor.createdBy) && Objects.equals(this.organization, trustor.organization) && Objects.equals(this.authorization, trustor.authorization) && Objects.equals(this.selfUri, trustor.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.enabled, this.dateCreated, this.createdBy, this.organization, this.authorization, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Trustor {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    authorization: ").append(this.toIndentedString(this.authorization)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

