/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.NluDetectionRequest;
import java.util.HashMap;
import java.util.Map;

public class PostLanguageunderstandingDomainVersionDetectRequest {
    private String domainId;
    private String domainVersionId;
    private NluDetectionRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public PostLanguageunderstandingDomainVersionDetectRequest withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public String getDomainVersionId() {
        return this.domainVersionId;
    }

    public void setDomainVersionId(String domainVersionId) {
        this.domainVersionId = domainVersionId;
    }

    public PostLanguageunderstandingDomainVersionDetectRequest withDomainVersionId(String domainVersionId) {
        this.setDomainVersionId(domainVersionId);
        return this;
    }

    public NluDetectionRequest getBody() {
        return this.body;
    }

    public void setBody(NluDetectionRequest body) {
        this.body = body;
    }

    public PostLanguageunderstandingDomainVersionDetectRequest withBody(NluDetectionRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostLanguageunderstandingDomainVersionDetectRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<NluDetectionRequest> withHttpInfo() {
        if (this.domainId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PostLanguageunderstandingDomainVersionDetectRequest.");
        }
        if (this.domainVersionId == null) {
            throw new IllegalStateException("Missing the required parameter 'domainVersionId' when building request for PostLanguageunderstandingDomainVersionDetectRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostLanguageunderstandingDomainVersionDetectRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/languageunderstanding/domains/{domainId}/versions/{domainVersionId}/detect").withPathParameter("domainId", this.domainId).withPathParameter("domainVersionId", this.domainVersionId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String domainId, String domainVersionId, NluDetectionRequest body) {
        return new Builder().withRequiredParams(domainId, domainVersionId, body);
    }

    public static class Builder {
        private final PostLanguageunderstandingDomainVersionDetectRequest request = new PostLanguageunderstandingDomainVersionDetectRequest();

        private Builder() {
        }

        public Builder withDomainId(String domainId) {
            this.request.setDomainId(domainId);
            return this;
        }

        public Builder withDomainVersionId(String domainVersionId) {
            this.request.setDomainVersionId(domainVersionId);
            return this;
        }

        public Builder withBody(NluDetectionRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String domainId, String domainVersionId, NluDetectionRequest body) {
            this.request.setDomainId(domainId);
            this.request.setDomainVersionId(domainVersionId);
            this.request.setBody(body);
            return this;
        }

        public PostLanguageunderstandingDomainVersionDetectRequest build() {
            if (this.request.domainId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainId' when building request for PostLanguageunderstandingDomainVersionDetectRequest.");
            }
            if (this.request.domainVersionId == null) {
                throw new IllegalStateException("Missing the required parameter 'domainVersionId' when building request for PostLanguageunderstandingDomainVersionDetectRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostLanguageunderstandingDomainVersionDetectRequest.");
            }
            return this.request;
        }
    }
}

