/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2;

import com.google.common.collect.Lists;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class JodaApiDateFormat
extends DateFormat {
    private final List<DateTimeFormatter> formats;

    public JodaApiDateFormat() {
        this.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        this.setNumberFormat(NumberFormat.getInstance());
        this.formats = Lists.newArrayList((Object[])new DateTimeFormatter[]{ISODateTimeFormat.dateTimeParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ"), DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS")});
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        StringBuffer stringBuffer = new StringBuffer();
        this.formats.get(0).printTo(stringBuffer, (ReadableInstant)new Instant((Object)date));
        return stringBuffer;
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        for (DateTimeFormatter format : this.formats) {
            try {
                DateTime date = format.parseDateTime(source);
                if (date == null) continue;
                pos.setIndex(source.length() - 1);
                return date.toDate();
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

