/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="This is used to identify who the message is sent to, as well as who it was sent from. This information is channel specific - depends on capabilities to describe party by the platform")
public class MessagingRecipient
implements Serializable {
    private String nickname = null;
    private String id = null;
    private String image = null;
    private String firstName = null;
    private String lastName = null;
    private String email = null;

    @ApiModelProperty(example="null", value="Nickname/user name")
    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    public MessagingRecipient id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipient identifier specific for particular channel/integration. This is required when sending a message.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(example="null", value="Avatar image")
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    @ApiModelProperty(example="null", value="Sender's first name")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @ApiModelProperty(example="null", value="Sender's last name")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @ApiModelProperty(example="null", value="Sender's email address")
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingRecipient messagingRecipient = (MessagingRecipient)o;
        return Objects.equals(this.nickname, messagingRecipient.nickname) && Objects.equals(this.id, messagingRecipient.id) && Objects.equals(this.image, messagingRecipient.image) && Objects.equals(this.firstName, messagingRecipient.firstName) && Objects.equals(this.lastName, messagingRecipient.lastName) && Objects.equals(this.email, messagingRecipient.email);
    }

    public int hashCode() {
        return Objects.hash(this.nickname, this.id, this.image, this.firstName, this.lastName, this.email);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingRecipient {\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

