/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class MessagingIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private StatusEnum status = null;
    private MessengerTypeEnum messengerType = null;
    private DomainEntityRef recipient = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private Integer version = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", required=true, value="A unique Integration Id")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(example="null", value="The status of the Integration")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", required=true, value="The type of Messaging Integration")
    @JsonProperty(value="messengerType")
    public MessengerTypeEnum getMessengerType() {
        return this.messengerType;
    }

    public MessagingIntegration recipient(DomainEntityRef recipient) {
        this.recipient = recipient;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipient associated to the Integration. This recipient is used to associate a flow to an integration")
    @JsonProperty(value="recipient")
    public DomainEntityRef getRecipient() {
        return this.recipient;
    }

    public void setRecipient(DomainEntityRef recipient) {
        this.recipient = recipient;
    }

    @ApiModelProperty(example="null", value="Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Date this Integration was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public MessagingIntegration createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that created this Integration")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public MessagingIntegration modifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that last modified this Integration")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessagingIntegration messagingIntegration = (MessagingIntegration)o;
        return Objects.equals(this.id, messagingIntegration.id) && Objects.equals(this.name, messagingIntegration.name) && Objects.equals((Object)this.status, (Object)messagingIntegration.status) && Objects.equals((Object)this.messengerType, (Object)messagingIntegration.messengerType) && Objects.equals(this.recipient, messagingIntegration.recipient) && Objects.equals(this.dateCreated, messagingIntegration.dateCreated) && Objects.equals(this.dateModified, messagingIntegration.dateModified) && Objects.equals(this.createdBy, messagingIntegration.createdBy) && Objects.equals(this.modifiedBy, messagingIntegration.modifiedBy) && Objects.equals(this.version, messagingIntegration.version) && Objects.equals(this.selfUri, messagingIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.status, this.messengerType, this.recipient, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessagingIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    messengerType: ").append(this.toIndentedString((Object)this.messengerType)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MessengerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        FACEBOOK("facebook"),
        TWITTER("twitter"),
        LINE("line"),
        WHATSAPP("whatsapp"),
        WEBMESSAGING("webmessaging");

        private String value;

        private MessengerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessengerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessengerTypeEnum value : MessengerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessengerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        INACTIVE("Inactive"),
        ERROR("Error"),
        STARTING("Starting"),
        INCOMPLETE("Incomplete"),
        DELETING("Deleting"),
        DELETIONFAILED("DeletionFailed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

