/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.GDPRSubject;
import com.mypurecloud.sdk.v2.model.ReplacementTerm;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class GDPRRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private DomainEntityRef createdBy = null;
    private List<ReplacementTerm> replacementTerms = new ArrayList<ReplacementTerm>();
    private RequestTypeEnum requestType = null;
    private Date createdDate = null;
    private StatusEnum status = null;
    private GDPRSubject subject = null;
    private String resultsUrl = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public GDPRRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GDPRRequest createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The user that created this request")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public GDPRRequest replacementTerms(List<ReplacementTerm> replacementTerms) {
        this.replacementTerms = replacementTerms;
        return this;
    }

    @ApiModelProperty(example="null", value="The replacement terms for the provided search terms, in the case of a GDPR_UPDATE request")
    @JsonProperty(value="replacementTerms")
    public List<ReplacementTerm> getReplacementTerms() {
        return this.replacementTerms;
    }

    public void setReplacementTerms(List<ReplacementTerm> replacementTerms) {
        this.replacementTerms = replacementTerms;
    }

    public GDPRRequest requestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of GDPR request")
    @JsonProperty(value="requestType")
    public RequestTypeEnum getRequestType() {
        return this.requestType;
    }

    public void setRequestType(RequestTypeEnum requestType) {
        this.requestType = requestType;
    }

    @ApiModelProperty(example="null", required=true, value="When the request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the request")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public GDPRRequest subject(GDPRSubject subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The subject of the GDPR request")
    @JsonProperty(value="subject")
    public GDPRSubject getSubject() {
        return this.subject;
    }

    public void setSubject(GDPRSubject subject) {
        this.subject = subject;
    }

    @ApiModelProperty(example="null", value="The location where the results of the request can be retrieved")
    @JsonProperty(value="resultsUrl")
    public String getResultsUrl() {
        return this.resultsUrl;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GDPRRequest gDPRRequest = (GDPRRequest)o;
        return Objects.equals(this.id, gDPRRequest.id) && Objects.equals(this.name, gDPRRequest.name) && Objects.equals(this.createdBy, gDPRRequest.createdBy) && Objects.equals(this.replacementTerms, gDPRRequest.replacementTerms) && Objects.equals((Object)this.requestType, (Object)gDPRRequest.requestType) && Objects.equals(this.createdDate, gDPRRequest.createdDate) && Objects.equals((Object)this.status, (Object)gDPRRequest.status) && Objects.equals(this.subject, gDPRRequest.subject) && Objects.equals(this.resultsUrl, gDPRRequest.resultsUrl) && Objects.equals(this.selfUri, gDPRRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.createdBy, this.replacementTerms, this.requestType, this.createdDate, this.status, this.subject, this.resultsUrl, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GDPRRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    replacementTerms: ").append(this.toIndentedString(this.replacementTerms)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString((Object)this.requestType)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    resultsUrl: ").append(this.toIndentedString(this.resultsUrl)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INITIATED("INITIATED"),
        SEARCHING("SEARCHING"),
        UPDATING("UPDATING"),
        DELETING("DELETING"),
        COMPLETED("COMPLETED"),
        ERROR("ERROR"),
        FINALIZING("FINALIZING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum RequestTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GDPR_EXPORT("GDPR_EXPORT"),
        GDPR_UPDATE("GDPR_UPDATE"),
        GDPR_DELETE("GDPR_DELETE");

        private String value;

        private RequestTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RequestTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RequestTypeEnum value : RequestTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RequestTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

