/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.Address;
import com.mypurecloud.sdk.v2.model.AfterCallWork;
import com.mypurecloud.sdk.v2.model.Wrapup;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Video
implements Serializable {
    private StateEnum state = null;
    private String id = null;
    private String context = null;
    private Boolean audioMuted = null;
    private Boolean videoMuted = null;
    private Boolean sharingScreen = null;
    private Integer peerCount = null;
    private DisconnectTypeEnum disconnectType = null;
    private Date startAlertingTime = null;
    private Date connectedTime = null;
    private Date disconnectedTime = null;
    private String provider = null;
    private String peerId = null;
    private List<String> msids = new ArrayList<String>();
    private Address self = null;
    private Wrapup wrapup = null;
    private AfterCallWork afterCallWork = null;
    private Boolean afterCallWorkRequired = null;

    public Video state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The connection state of this communication.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public Video id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Video context(String context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", value="The room id context (xmpp jid) for the conference session.")
    @JsonProperty(value="context")
    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public Video audioMuted(Boolean audioMuted) {
        this.audioMuted = audioMuted;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether this participant has muted their outgoing audio.")
    @JsonProperty(value="audioMuted")
    public Boolean getAudioMuted() {
        return this.audioMuted;
    }

    public void setAudioMuted(Boolean audioMuted) {
        this.audioMuted = audioMuted;
    }

    public Video videoMuted(Boolean videoMuted) {
        this.videoMuted = videoMuted;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether this participant has muted/paused their outgoing video.")
    @JsonProperty(value="videoMuted")
    public Boolean getVideoMuted() {
        return this.videoMuted;
    }

    public void setVideoMuted(Boolean videoMuted) {
        this.videoMuted = videoMuted;
    }

    public Video sharingScreen(Boolean sharingScreen) {
        this.sharingScreen = sharingScreen;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether this participant is sharing their screen to the session.")
    @JsonProperty(value="sharingScreen")
    public Boolean getSharingScreen() {
        return this.sharingScreen;
    }

    public void setSharingScreen(Boolean sharingScreen) {
        this.sharingScreen = sharingScreen;
    }

    public Video peerCount(Integer peerCount) {
        this.peerCount = peerCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of peer participants from the perspective of the participant in the conference.")
    @JsonProperty(value="peerCount")
    public Integer getPeerCount() {
        return this.peerCount;
    }

    public void setPeerCount(Integer peerCount) {
        this.peerCount = peerCount;
    }

    public Video disconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
        return this;
    }

    @ApiModelProperty(example="null", value="System defined string indicating what caused the communication to disconnect. Will be null until the communication disconnects.")
    @JsonProperty(value="disconnectType")
    public DisconnectTypeEnum getDisconnectType() {
        return this.disconnectType;
    }

    public void setDisconnectType(DisconnectTypeEnum disconnectType) {
        this.disconnectType = disconnectType;
    }

    public Video startAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp the communication has when it is first put into an alerting state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startAlertingTime")
    public Date getStartAlertingTime() {
        return this.startAlertingTime;
    }

    public void setStartAlertingTime(Date startAlertingTime) {
        this.startAlertingTime = startAlertingTime;
    }

    public Video connectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication was connected in the cloud clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="connectedTime")
    public Date getConnectedTime() {
        return this.connectedTime;
    }

    public void setConnectedTime(Date connectedTime) {
        this.connectedTime = connectedTime;
    }

    public Video disconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp when this communication disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="disconnectedTime")
    public Date getDisconnectedTime() {
        return this.disconnectedTime;
    }

    public void setDisconnectedTime(Date disconnectedTime) {
        this.disconnectedTime = disconnectedTime;
    }

    public Video provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(example="null", value="The source provider for the video.")
    @JsonProperty(value="provider")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public Video peerId(String peerId) {
        this.peerId = peerId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of the peer communication corresponding to a matching leg for this communication.")
    @JsonProperty(value="peerId")
    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peerId) {
        this.peerId = peerId;
    }

    public Video msids(List<String> msids) {
        this.msids = msids;
        return this;
    }

    @ApiModelProperty(example="null", value="List of media stream ids")
    @JsonProperty(value="msids")
    public List<String> getMsids() {
        return this.msids;
    }

    public void setMsids(List<String> msids) {
        this.msids = msids;
    }

    public Video self(Address self) {
        this.self = self;
        return this;
    }

    @ApiModelProperty(example="null", value="Address and name data for a call endpoint.")
    @JsonProperty(value="self")
    public Address getSelf() {
        return this.self;
    }

    public void setSelf(Address self) {
        this.self = self;
    }

    public Video wrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
        return this;
    }

    @ApiModelProperty(example="null", value="Call wrap up or disposition data.")
    @JsonProperty(value="wrapup")
    public Wrapup getWrapup() {
        return this.wrapup;
    }

    public void setWrapup(Wrapup wrapup) {
        this.wrapup = wrapup;
    }

    public Video afterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
        return this;
    }

    @ApiModelProperty(example="null", value="After-call work for the communication.")
    @JsonProperty(value="afterCallWork")
    public AfterCallWork getAfterCallWork() {
        return this.afterCallWork;
    }

    public void setAfterCallWork(AfterCallWork afterCallWork) {
        this.afterCallWork = afterCallWork;
    }

    public Video afterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates if after-call work is required for a communication. Only used when the ACW Setting is Agent Requested.")
    @JsonProperty(value="afterCallWorkRequired")
    public Boolean getAfterCallWorkRequired() {
        return this.afterCallWorkRequired;
    }

    public void setAfterCallWorkRequired(Boolean afterCallWorkRequired) {
        this.afterCallWorkRequired = afterCallWorkRequired;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Video video = (Video)o;
        return Objects.equals((Object)this.state, (Object)video.state) && Objects.equals(this.id, video.id) && Objects.equals(this.context, video.context) && Objects.equals(this.audioMuted, video.audioMuted) && Objects.equals(this.videoMuted, video.videoMuted) && Objects.equals(this.sharingScreen, video.sharingScreen) && Objects.equals(this.peerCount, video.peerCount) && Objects.equals((Object)this.disconnectType, (Object)video.disconnectType) && Objects.equals(this.startAlertingTime, video.startAlertingTime) && Objects.equals(this.connectedTime, video.connectedTime) && Objects.equals(this.disconnectedTime, video.disconnectedTime) && Objects.equals(this.provider, video.provider) && Objects.equals(this.peerId, video.peerId) && Objects.equals(this.msids, video.msids) && Objects.equals(this.self, video.self) && Objects.equals(this.wrapup, video.wrapup) && Objects.equals(this.afterCallWork, video.afterCallWork) && Objects.equals(this.afterCallWorkRequired, video.afterCallWorkRequired);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.id, this.context, this.audioMuted, this.videoMuted, this.sharingScreen, this.peerCount, this.disconnectType, this.startAlertingTime, this.connectedTime, this.disconnectedTime, this.provider, this.peerId, this.msids, this.self, this.wrapup, this.afterCallWork, this.afterCallWorkRequired});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Video {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    audioMuted: ").append(this.toIndentedString(this.audioMuted)).append("\n");
        sb.append("    videoMuted: ").append(this.toIndentedString(this.videoMuted)).append("\n");
        sb.append("    sharingScreen: ").append(this.toIndentedString(this.sharingScreen)).append("\n");
        sb.append("    peerCount: ").append(this.toIndentedString(this.peerCount)).append("\n");
        sb.append("    disconnectType: ").append(this.toIndentedString((Object)this.disconnectType)).append("\n");
        sb.append("    startAlertingTime: ").append(this.toIndentedString(this.startAlertingTime)).append("\n");
        sb.append("    connectedTime: ").append(this.toIndentedString(this.connectedTime)).append("\n");
        sb.append("    disconnectedTime: ").append(this.toIndentedString(this.disconnectedTime)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    peerId: ").append(this.toIndentedString(this.peerId)).append("\n");
        sb.append("    msids: ").append(this.toIndentedString(this.msids)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    wrapup: ").append(this.toIndentedString(this.wrapup)).append("\n");
        sb.append("    afterCallWork: ").append(this.toIndentedString(this.afterCallWork)).append("\n");
        sb.append("    afterCallWorkRequired: ").append(this.toIndentedString(this.afterCallWorkRequired)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DisconnectTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ENDPOINT("endpoint"),
        CLIENT("client"),
        SYSTEM("system"),
        TIMEOUT("timeout"),
        TRANSFER("transfer"),
        TRANSFER_CONFERENCE("transfer.conference"),
        TRANSFER_CONSULT("transfer.consult"),
        TRANSFER_FORWARD("transfer.forward"),
        TRANSFER_NOANSWER("transfer.noanswer"),
        TRANSFER_NOTAVAILABLE("transfer.notavailable"),
        TRANSPORT_FAILURE("transport.failure"),
        ERROR("error"),
        PEER("peer"),
        OTHER("other"),
        SPAM("spam"),
        UNCALLABLE("uncallable");

        private String value;

        private DisconnectTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DisconnectTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DisconnectTypeEnum value : DisconnectTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DisconnectTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALERTING("alerting"),
        DIALING("dialing"),
        CONTACTING("contacting"),
        OFFERING("offering"),
        CONNECTED("connected"),
        DISCONNECTED("disconnected"),
        TERMINATED("terminated"),
        NONE("none");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

