/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="State information for an import job of rows to a datatable")
public class DataTableImportJob
implements Serializable {
    private String id = null;
    private String name = null;
    private AddressableEntityRef owner = null;
    private StatusEnum status = null;
    private Date dateCreated = null;
    private Date dateCompleted = null;
    private String uploadURI = null;
    private ImportModeEnum importMode = null;
    private ErrorBody errorInformation = null;
    private Integer countRecordsUpdated = null;
    private Integer countRecordsDeleted = null;
    private Integer countRecordsFailed = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DataTableImportJob name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataTableImportJob owner(AddressableEntityRef owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud user who started the import job")
    @JsonProperty(value="owner")
    public AddressableEntityRef getOwner() {
        return this.owner;
    }

    public void setOwner(AddressableEntityRef owner) {
        this.owner = owner;
    }

    public DataTableImportJob status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The status of the import job")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DataTableImportJob dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the import began. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public DataTableImportJob dateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    @ApiModelProperty(example="null", value="The timestamp of when the import stopped (either successfully or unsuccessfully). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCompleted")
    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(Date dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public DataTableImportJob uploadURI(String uploadURI) {
        this.uploadURI = uploadURI;
        return this;
    }

    @ApiModelProperty(example="null", value="The URL of the location at which the caller can upload the file to be imported")
    @JsonProperty(value="uploadURI")
    public String getUploadURI() {
        return this.uploadURI;
    }

    public void setUploadURI(String uploadURI) {
        this.uploadURI = uploadURI;
    }

    public DataTableImportJob importMode(ImportModeEnum importMode) {
        this.importMode = importMode;
        return this;
    }

    @ApiModelProperty(example="null", value="The indication of whether the processing should remove rows that don't appear in the import file")
    @JsonProperty(value="importMode")
    public ImportModeEnum getImportMode() {
        return this.importMode;
    }

    public void setImportMode(ImportModeEnum importMode) {
        this.importMode = importMode;
    }

    public DataTableImportJob errorInformation(ErrorBody errorInformation) {
        this.errorInformation = errorInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="Any error information, or null of the processing is not in an error state")
    @JsonProperty(value="errorInformation")
    public ErrorBody getErrorInformation() {
        return this.errorInformation;
    }

    public void setErrorInformation(ErrorBody errorInformation) {
        this.errorInformation = errorInformation;
    }

    public DataTableImportJob countRecordsUpdated(Integer countRecordsUpdated) {
        this.countRecordsUpdated = countRecordsUpdated;
        return this;
    }

    @ApiModelProperty(example="null", value="The current count of the number of records processed")
    @JsonProperty(value="countRecordsUpdated")
    public Integer getCountRecordsUpdated() {
        return this.countRecordsUpdated;
    }

    public void setCountRecordsUpdated(Integer countRecordsUpdated) {
        this.countRecordsUpdated = countRecordsUpdated;
    }

    public DataTableImportJob countRecordsDeleted(Integer countRecordsDeleted) {
        this.countRecordsDeleted = countRecordsDeleted;
        return this;
    }

    @ApiModelProperty(example="null", value="The current count of the number of records deleted")
    @JsonProperty(value="countRecordsDeleted")
    public Integer getCountRecordsDeleted() {
        return this.countRecordsDeleted;
    }

    public void setCountRecordsDeleted(Integer countRecordsDeleted) {
        this.countRecordsDeleted = countRecordsDeleted;
    }

    public DataTableImportJob countRecordsFailed(Integer countRecordsFailed) {
        this.countRecordsFailed = countRecordsFailed;
        return this;
    }

    @ApiModelProperty(example="null", value="The current count of the number of records that failed to import")
    @JsonProperty(value="countRecordsFailed")
    public Integer getCountRecordsFailed() {
        return this.countRecordsFailed;
    }

    public void setCountRecordsFailed(Integer countRecordsFailed) {
        this.countRecordsFailed = countRecordsFailed;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTableImportJob dataTableImportJob = (DataTableImportJob)o;
        return Objects.equals(this.id, dataTableImportJob.id) && Objects.equals(this.name, dataTableImportJob.name) && Objects.equals(this.owner, dataTableImportJob.owner) && Objects.equals((Object)this.status, (Object)dataTableImportJob.status) && Objects.equals(this.dateCreated, dataTableImportJob.dateCreated) && Objects.equals(this.dateCompleted, dataTableImportJob.dateCompleted) && Objects.equals(this.uploadURI, dataTableImportJob.uploadURI) && Objects.equals((Object)this.importMode, (Object)dataTableImportJob.importMode) && Objects.equals(this.errorInformation, dataTableImportJob.errorInformation) && Objects.equals(this.countRecordsUpdated, dataTableImportJob.countRecordsUpdated) && Objects.equals(this.countRecordsDeleted, dataTableImportJob.countRecordsDeleted) && Objects.equals(this.countRecordsFailed, dataTableImportJob.countRecordsFailed) && Objects.equals(this.selfUri, dataTableImportJob.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.owner, this.status, this.dateCreated, this.dateCompleted, this.uploadURI, this.importMode, this.errorInformation, this.countRecordsUpdated, this.countRecordsDeleted, this.countRecordsFailed, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataTableImportJob {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    uploadURI: ").append(this.toIndentedString(this.uploadURI)).append("\n");
        sb.append("    importMode: ").append(this.toIndentedString((Object)this.importMode)).append("\n");
        sb.append("    errorInformation: ").append(this.toIndentedString(this.errorInformation)).append("\n");
        sb.append("    countRecordsUpdated: ").append(this.toIndentedString(this.countRecordsUpdated)).append("\n");
        sb.append("    countRecordsDeleted: ").append(this.toIndentedString(this.countRecordsDeleted)).append("\n");
        sb.append("    countRecordsFailed: ").append(this.toIndentedString(this.countRecordsFailed)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ImportModeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        REPLACEALL("ReplaceAll"),
        APPEND("Append");

        private String value;

        private ImportModeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ImportModeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ImportModeEnum value : ImportModeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ImportModeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WAITINGFORUPLOAD("WaitingForUpload"),
        PROCESSING("Processing"),
        FAILED("Failed"),
        SUCCEEDED("Succeeded");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

