/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.OAuthClientRequest;
import java.util.HashMap;
import java.util.Map;

public class PutOauthClientRequest {
    private String clientId;
    private OAuthClientRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public PutOauthClientRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public OAuthClientRequest getBody() {
        return this.body;
    }

    public void setBody(OAuthClientRequest body) {
        this.body = body;
    }

    public PutOauthClientRequest withBody(OAuthClientRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOauthClientRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<OAuthClientRequest> withHttpInfo() {
        if (this.clientId == null) {
            throw new IllegalStateException("Missing the required parameter 'clientId' when building request for PutOauthClientRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOauthClientRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/oauth/clients/{clientId}").withPathParameter("clientId", this.clientId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String clientId, OAuthClientRequest body) {
        return new Builder().withRequiredParams(clientId, body);
    }

    public static class Builder {
        private final PutOauthClientRequest request = new PutOauthClientRequest();

        private Builder() {
        }

        public Builder withClientId(String clientId) {
            this.request.setClientId(clientId);
            return this;
        }

        public Builder withBody(OAuthClientRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String clientId, OAuthClientRequest body) {
            this.request.setClientId(clientId);
            this.request.setBody(body);
            return this;
        }

        public PutOauthClientRequest build() {
            if (this.request.clientId == null) {
                throw new IllegalStateException("Missing the required parameter 'clientId' when building request for PutOauthClientRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutOauthClientRequest.");
            }
            return this.request;
        }
    }
}

