/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.KeyValue;
import com.mypurecloud.sdk.v2.model.ServiceLevel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class ActionTarget
implements Serializable {
    private String id = null;
    private String name = null;
    private List<KeyValue> userData = new ArrayList<KeyValue>();
    private List<SupportedMediaTypesEnum> supportedMediaTypes = new ArrayList<SupportedMediaTypesEnum>();
    private StateEnum state = null;
    private String description = null;
    private ServiceLevel serviceLevel = null;
    private String selfUri = null;
    private Date createdDate = null;
    private Date modifiedDate = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ActionTarget name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActionTarget userData(List<KeyValue> userData) {
        this.userData = userData;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional user data associated with the target in key/value format.")
    @JsonProperty(value="userData")
    public List<KeyValue> getUserData() {
        return this.userData;
    }

    public void setUserData(List<KeyValue> userData) {
        this.userData = userData;
    }

    public ActionTarget supportedMediaTypes(List<SupportedMediaTypesEnum> supportedMediaTypes) {
        this.supportedMediaTypes = supportedMediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="Supported media types of the target.")
    @JsonProperty(value="supportedMediaTypes")
    public List<SupportedMediaTypesEnum> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public void setSupportedMediaTypes(List<SupportedMediaTypesEnum> supportedMediaTypes) {
        this.supportedMediaTypes = supportedMediaTypes;
    }

    public ActionTarget state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the state of the target.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public ActionTarget description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the target.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ActionTarget serviceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
        return this;
    }

    @ApiModelProperty(example="null", value="Service Level of the action target. Chat offers for the target will be throttled with the aim of achieving this service level.")
    @JsonProperty(value="serviceLevel")
    public ServiceLevel getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(ServiceLevel serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public ActionTarget createdDate(Date createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the target was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="createdDate")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public ActionTarget modifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date the target was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="modifiedDate")
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionTarget actionTarget = (ActionTarget)o;
        return Objects.equals(this.id, actionTarget.id) && Objects.equals(this.name, actionTarget.name) && Objects.equals(this.userData, actionTarget.userData) && Objects.equals(this.supportedMediaTypes, actionTarget.supportedMediaTypes) && Objects.equals((Object)this.state, (Object)actionTarget.state) && Objects.equals(this.description, actionTarget.description) && Objects.equals(this.serviceLevel, actionTarget.serviceLevel) && Objects.equals(this.selfUri, actionTarget.selfUri) && Objects.equals(this.createdDate, actionTarget.createdDate) && Objects.equals(this.modifiedDate, actionTarget.modifiedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.userData, this.supportedMediaTypes, this.state, this.description, this.serviceLevel, this.selfUri, this.createdDate, this.modifiedDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionTarget {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    userData: ").append(this.toIndentedString(this.userData)).append("\n");
        sb.append("    supportedMediaTypes: ").append(this.toIndentedString(this.supportedMediaTypes)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    serviceLevel: ").append(this.toIndentedString(this.serviceLevel)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum SupportedMediaTypesEnum {
        CALLBACK("callback"),
        CALL("call"),
        EMAIL("email"),
        GENERIC("generic"),
        MESSAGING("messaging"),
        SOCIAL("social"),
        WEBCHAT("webchat");

        private String value;

        private SupportedMediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SupportedMediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SupportedMediaTypesEnum value : SupportedMediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SupportedMediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

